/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.imports;

import cn.afterturn.easypoi.entity.BaseTypeConstants;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelCollectionParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelImportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.excel.entity.result.ExcelVerifyHandlerResult;
import cn.afterturn.easypoi.excel.imports.CellValueService;
import cn.afterturn.easypoi.excel.imports.base.ImportBaseService;
import cn.afterturn.easypoi.excel.imports.recursive.ExcelImportForkJoinWork;
import cn.afterturn.easypoi.exception.excel.ExcelImportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelImportEnum;
import cn.afterturn.easypoi.handler.inter.IExcelDataModel;
import cn.afterturn.easypoi.handler.inter.IExcelModel;
import cn.afterturn.easypoi.util.PoiCellUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.util.PoiReflectorUtil;
import cn.afterturn.easypoi.util.PoiValidationUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportService
extends ImportBaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportService.class);
    private CellValueService cellValueServer;
    private boolean verifyFail = false;
    private CellStyle errorCellStyle;
    private List<Row> successRow = new ArrayList<Row>();
    private List<Row> failRow = new ArrayList<Row>();
    private List failCollection = new ArrayList();

    public ExcelImportService() {
        this.cellValueServer = new CellValueService();
    }

    public void addListContinue(Object object, ExcelCollectionParams param, Row row, Map<Integer, String> titlemap, String targetId, Map<String, PictureData> pictures, ImportParams params, StringBuilder errorMsg) throws Exception {
        Collection collection = (Collection)PoiReflectorUtil.fromCache(object.getClass()).getValue(object, param.getName());
        Object entity = PoiPublicUtil.createObject(param.getType(), targetId);
        if (entity instanceof IExcelDataModel) {
            ((IExcelDataModel)entity).setRowNum(row.getRowNum());
        }
        boolean isUsed = false;
        for (int i = row.getFirstCellNum(); i < titlemap.size(); ++i) {
            block7: {
                Cell cell = row.getCell(i);
                String titleString = titlemap.get(i);
                if (!param.getExcelParams().containsKey(titleString)) continue;
                if (param.getExcelParams().get(titleString).getType() == BaseTypeConstants.IMAGE_TYPE.intValue()) {
                    String picId = row.getRowNum() + "_" + i;
                    this.saveImage(entity, picId, param.getExcelParams(), titleString, pictures, params);
                } else {
                    try {
                        this.saveFieldValue(params, entity, cell, param.getExcelParams(), titleString, row);
                    }
                    catch (ExcelImportException e) {
                        if (!params.isNeedVerify() || !ExcelImportEnum.GET_VALUE_ERROR.equals((Object)e.getType())) break block7;
                        errorMsg.append(" ").append(titleString).append(ExcelImportEnum.GET_VALUE_ERROR.getMsg());
                    }
                }
            }
            isUsed = true;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private String getKeyValue(Cell cell) {
        String obj = PoiCellUtil.getCellValue(cell);
        return obj == null ? null : obj.toString().trim();
    }

    private String getSaveUrl(ExcelImportEntity excelImportEntity, Object object) throws Exception {
        String url = "";
        if ("/excel/upload/img".equals(excelImportEntity.getSaveUrl())) {
            if (excelImportEntity.getMethods() != null && excelImportEntity.getMethods().size() > 0) {
                object = this.getFieldBySomeMethod(excelImportEntity.getMethods(), object);
            }
            url = object.getClass().getName().split("\\.")[object.getClass().getName().split("\\.").length - 1];
            return excelImportEntity.getSaveUrl() + File.separator + url;
        }
        return excelImportEntity.getSaveUrl();
    }

    /*
     * Unable to fully structure code
     */
    private <T> List<T> importExcel(Collection<T> result, Sheet sheet, Class<?> pojoClass, ImportParams params, Map<String, PictureData> pictures) throws Exception {
        collection = new ArrayList<E>();
        excelParams = new HashMap<String, ExcelImportEntity>();
        excelCollection = new ArrayList<ExcelCollectionParams>();
        targetId = null;
        this.i18nHandler = params.getI18nHandler();
        isMap = Map.class.equals(pojoClass);
        if (!isMap) {
            fileds = PoiPublicUtil.getClassFields(pojoClass);
            etarget = pojoClass.getAnnotation(ExcelTarget.class);
            if (etarget != null) {
                targetId = etarget.value();
            }
            this.getAllExcelField(targetId, fileds, excelParams, excelCollection, pojoClass, null, null);
        }
        rows = sheet.rowIterator();
        for (j = 0; j < params.getTitleRows(); ++j) {
            rows.next();
        }
        titlemap = this.getTitleMap(rows, params, excelCollection, excelParams);
        this.checkIsValidTemplate(titlemap, excelParams, params, excelCollection);
        row = null;
        object = null;
        readRow = 1;
        for (i = 0; i < params.getStartRows(); ++i) {
            rows.next();
        }
        if (excelCollection.size() > 0 && params.getKeyIndex() == null) {
            params.setKeyIndex(0);
        }
        endRow = sheet.getLastRowNum() - params.getLastOfInvalidRow();
        if (params.getReadRows() > 0) {
            endRow = Math.min(params.getReadRows(), endRow);
        }
        if (params.isConcurrentTask()) {
            forkJoinPool = new ForkJoinPool();
            task = new ExcelImportForkJoinWork(params.getStartRows() + params.getHeadRows() + params.getTitleRows(), endRow, sheet, params, pojoClass, this, targetId, titlemap, excelParams);
            forkJoinResult = forkJoinPool.invoke(task);
            collection = forkJoinResult.getList();
            this.failCollection = forkJoinResult.getFailList();
        } else {
            while (rows.hasNext() && (row = (Row)rows.next()).getRowNum() <= endRow) {
                if (row.getLastCellNum() < 0) continue;
                if (isMap && object != null) {
                    ((Map)object).put("excelRowNum", row.getRowNum());
                }
                errorMsg = new StringBuilder();
                if (params.getKeyIndex() != null && (row.getCell(params.getKeyIndex().intValue()) == null || StringUtils.isEmpty((CharSequence)this.getKeyValue(row.getCell(params.getKeyIndex().intValue())))) && object != null) {
                    for (ExcelCollectionParams param : excelCollection) {
                        this.addListContinue(object, param, row, titlemap, targetId, pictures, params, errorMsg);
                    }
                } else {
                    object = PoiPublicUtil.createObject(pojoClass, targetId);
                    try {
                        keys = titlemap.keySet();
                        for (Integer cn : keys) {
                            cell = row.getCell(cn.intValue());
                            titleString = titlemap.get(cn);
                            if (!excelParams.containsKey(titleString) && !isMap) continue;
                            if (excelParams.get(titleString) != null && ((ExcelImportEntity)excelParams.get(titleString)).getType() == BaseTypeConstants.IMAGE_TYPE.intValue()) {
                                picId = row.getRowNum() + "_" + cn;
                                this.saveImage(object, picId, excelParams, titleString, pictures, params);
                                continue;
                            }
                            try {
                                this.saveFieldValue(params, object, cell, excelParams, titleString, row);
                            }
                            catch (ExcelImportException e) {
                                if (!params.isNeedVerify() || !ExcelImportEnum.GET_VALUE_ERROR.equals((Object)e.getType())) continue;
                                errorMsg.append(" ").append(titleString).append(ExcelImportEnum.GET_VALUE_ERROR.getMsg());
                            }
                        }
                        if (object instanceof IExcelDataModel) {
                            ((IExcelDataModel)object).setRowNum(row.getRowNum());
                        }
                        for (ExcelCollectionParams param : excelCollection) {
                            this.addListContinue(object, param, row, titlemap, targetId, pictures, params, errorMsg);
                        }
                        if (this.verifyingDataValidity(object, row, params, isMap, errorMsg)) {
                            collection.add(object);
                        }
                        this.failCollection.add(object);
                    }
                    catch (ExcelImportException e) {
                        ExcelImportService.LOGGER.error("excel import error , row num:{},obj:{}", (Object)readRow, (Object)ReflectionToStringBuilder.toString((Object)object));
                        if (e.getType().equals((Object)ExcelImportEnum.VERIFY_ERROR)) ** GOTO lbl88
                        throw new ExcelImportException(e.getType(), (Throwable)e);
                    }
                    catch (Exception e) {
                        ExcelImportService.LOGGER.error("excel import error , row num:{},obj:{}", (Object)readRow, (Object)ReflectionToStringBuilder.toString((Object)object));
                        throw new RuntimeException(e);
                    }
                }
lbl88:
                // 4 sources

                ++readRow;
            }
        }
        return collection;
    }

    public boolean verifyingDataValidity(Object object, Row row, ImportParams params, boolean isMap, StringBuilder fieldErrorMsg) {
        ExcelVerifyHandlerResult result;
        IExcelModel model;
        String errorMsg;
        boolean isAdd = true;
        Cell cell = null;
        if (params.isNeedVerify() && StringUtils.isNotEmpty((CharSequence)(errorMsg = PoiValidationUtil.validation(object, params.getVerifyGroup())))) {
            cell = row.createCell((int)row.getLastCellNum());
            cell.setCellValue(errorMsg);
            if (object instanceof IExcelModel) {
                model = (IExcelModel)object;
                model.setErrorMsg(errorMsg);
            }
            isAdd = false;
            this.verifyFail = true;
        }
        if (params.getVerifyHandler() != null && !(result = params.getVerifyHandler().verifyHandler(object)).isSuccess()) {
            if (cell == null) {
                cell = row.createCell((int)row.getLastCellNum());
            }
            cell.setCellValue((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cell.getStringCellValue()}) ? cell.getStringCellValue() + "," : "") + result.getMsg());
            if (object instanceof IExcelModel) {
                model = (IExcelModel)object;
                model.setErrorMsg((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{model.getErrorMsg()}) ? model.getErrorMsg() + "," : "") + result.getMsg());
            }
            isAdd = false;
            this.verifyFail = true;
        }
        if ((params.isNeedVerify() || params.getVerifyHandler() != null) && fieldErrorMsg.length() > 0) {
            if (object instanceof IExcelModel) {
                IExcelModel model2 = (IExcelModel)object;
                model2.setErrorMsg((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{model2.getErrorMsg()}) ? model2.getErrorMsg() + "," : "") + fieldErrorMsg.toString());
            }
            if (cell == null) {
                cell = row.createCell((int)row.getLastCellNum());
            }
            cell.setCellValue((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cell.getStringCellValue()}) ? cell.getStringCellValue() + "," : "") + fieldErrorMsg.toString());
            isAdd = false;
            this.verifyFail = true;
        }
        if (cell != null) {
            cell.setCellStyle(this.errorCellStyle);
            this.failRow.add(row);
            if (isMap) {
                ((Map)object).put("excelErrorMsg", cell.getStringCellValue());
            }
        } else {
            this.successRow.add(row);
        }
        return isAdd;
    }

    private Map<Integer, String> getTitleMap(Iterator<Row> rows, ImportParams params, List<ExcelCollectionParams> excelCollection, Map<String, ExcelImportEntity> excelParams) {
        LinkedHashMap<Integer, String> titlemap = new LinkedHashMap<Integer, String>();
        String collectionName = null;
        ExcelCollectionParams collectionParams = null;
        Row row = null;
        for (int j = 0; j < params.getHeadRows(); ++j) {
            row = rows.next();
            if (row == null) continue;
            Iterator cellTitle = row.cellIterator();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = this.getKeyValue(cell);
                value = value.replace("\n", "");
                int i = cell.getColumnIndex();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                if (titlemap.containsKey(i)) {
                    collectionName = (String)titlemap.get(i);
                    collectionParams = this.getCollectionParams(excelCollection, collectionName);
                    titlemap.put(i, collectionName + "_" + value);
                } else if (StringUtils.isNotEmpty(collectionName) && collectionParams != null && collectionParams.getExcelParams().containsKey(collectionName + "_" + value)) {
                    titlemap.put(i, collectionName + "_" + value);
                } else {
                    collectionName = null;
                    collectionParams = null;
                }
                if (!StringUtils.isEmpty((CharSequence)collectionName)) continue;
                titlemap.put(i, value);
            }
        }
        Set<String> keys = excelParams.keySet();
        for (String key : keys) {
            if (!key.startsWith("FIXED_")) continue;
            String[] arr = key.split("_");
            titlemap.put(Integer.parseInt(arr[1]), key);
        }
        return titlemap;
    }

    private ExcelCollectionParams getCollectionParams(List<ExcelCollectionParams> excelCollection, String collectionName) {
        for (ExcelCollectionParams excelCollectionParams : excelCollection) {
            if (!collectionName.equals(excelCollectionParams.getExcelName())) continue;
            return excelCollectionParams;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelImportResult importExcelByIs(InputStream inputstream, Class<?> pojoClass, ImportParams params, boolean needMore) throws Exception {
        ExcelImportResult importResult;
        block17: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Excel import start ,class is {}", pojoClass);
            }
            ArrayList result = new ArrayList();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Workbook book;
                boolean isXSSFWorkbook;
                int len;
                byte[] buffer = new byte[1024];
                while ((len = inputstream.read(buffer)) > -1) {
                    baos.write(buffer, 0, len);
                }
                baos.flush();
                ByteArrayInputStream userIs = new ByteArrayInputStream(baos.toByteArray());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Excel clone success");
                }
                boolean bl = isXSSFWorkbook = !((book = WorkbookFactory.create((InputStream)userIs)) instanceof HSSFWorkbook);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Workbook create success");
                }
                importResult = new ExcelImportResult();
                this.createErrorCellStyle(book);
                for (int i = params.getStartSheetIndex(); i < params.getStartSheetIndex() + params.getSheetNum(); ++i) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" start to read excel by is ,startTime is {}", (Object)new Date());
                    }
                    Map<String, PictureData> pictures = isXSSFWorkbook ? PoiPublicUtil.getSheetPictrues07((XSSFSheet)book.getSheetAt(i), (XSSFWorkbook)book) : PoiPublicUtil.getSheetPictrues03((HSSFSheet)book.getSheetAt(i), (HSSFWorkbook)book);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" end to read excel by is ,endTime is {}", (Object)new Date());
                    }
                    result.addAll(this.importExcel(result, book.getSheetAt(i), pojoClass, params, pictures));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" end to read excel list by sheet ,endTime is {}", (Object)new Date());
                    }
                    if (!params.isReadSingleCell()) continue;
                    this.readSingleCell(importResult, book.getSheetAt(i), params);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(" read Key-Value ,endTime is {}", (Object)System.currentTimeMillis());
                }
                if (params.isNeedSave()) {
                    this.saveThisExcel(params, pojoClass, isXSSFWorkbook, book);
                }
                importResult.setList(result);
                if (!needMore) break block17;
                try (ByteArrayInputStream successIs = new ByteArrayInputStream(baos.toByteArray());){
                    Workbook successBook = WorkbookFactory.create((InputStream)successIs);
                    if (params.isVerifyFileSplit()) {
                        importResult.setWorkbook(this.removeSuperfluousRows(successBook, this.failRow, params));
                        importResult.setFailWorkbook(this.removeSuperfluousRows(book, this.successRow, params));
                    } else {
                        importResult.setWorkbook(book);
                    }
                    importResult.setFailList(this.failCollection);
                    importResult.setVerifyFail(this.verifyFail);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)baos);
            }
        }
        return importResult;
    }

    private Workbook removeSuperfluousRows(Workbook book, List<Row> rowList, ImportParams params) {
        for (int i = params.getStartSheetIndex(); i < params.getStartSheetIndex() + params.getSheetNum(); ++i) {
            for (int j = rowList.size() - 1; j >= 0; --j) {
                if (rowList.get(j).getRowNum() < rowList.get(j).getSheet().getLastRowNum()) {
                    book.getSheetAt(i).shiftRows(rowList.get(j).getRowNum() + 1, rowList.get(j).getSheet().getLastRowNum(), -1);
                    continue;
                }
                if (rowList.get(j).getRowNum() != rowList.get(j).getSheet().getLastRowNum()) continue;
                book.getSheetAt(i).createRow(rowList.get(j).getRowNum() + 1);
                book.getSheetAt(i).shiftRows(rowList.get(j).getRowNum() + 1, rowList.get(j).getSheet().getLastRowNum() + 1, -1);
            }
        }
        return book;
    }

    private void readSingleCell(ExcelImportResult result, Sheet sheet, ImportParams params) {
        int i;
        if (result.getMap() == null) {
            result.setMap(new HashMap<String, Object>());
        }
        for (i = 0; i < params.getTitleRows() + params.getHeadRows() + params.getStartRows(); ++i) {
            this.getSingleCellValueForRow(result, sheet.getRow(i), params);
        }
        for (i = sheet.getLastRowNum() - params.getLastOfInvalidRow(); i < sheet.getLastRowNum(); ++i) {
            this.getSingleCellValueForRow(result, sheet.getRow(i), params);
        }
    }

    private void getSingleCellValueForRow(ExcelImportResult result, Row row, ImportParams params) {
        short le = row.getLastCellNum();
        for (int j = row.getFirstCellNum(); j < le; ++j) {
            String text = PoiCellUtil.getCellValue(row.getCell(j));
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{text}) || !text.endsWith(params.getKeyMark())) continue;
            if (result.getMap().containsKey(text)) {
                if (result.getMap().get(text) instanceof String) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add((String)result.getMap().get(text));
                    result.getMap().put(text, list);
                }
                ((List)result.getMap().get(text)).add(PoiCellUtil.getCellValue(row.getCell(++j)));
                continue;
            }
            result.getMap().put(text, PoiCellUtil.getCellValue(row.getCell(++j)));
        }
    }

    private void checkIsValidTemplate(Map<Integer, String> titlemap, Map<String, ExcelImportEntity> excelParams, ImportParams params, List<ExcelCollectionParams> excelCollection) {
        if (params.getImportFields() != null) {
            if (params.isNeedCheckOrder()) {
                if (params.getImportFields().length != titlemap.size()) {
                    LOGGER.error("excel\u5217\u987a\u5e8f\u4e0d\u4e00\u81f4");
                    throw new ExcelImportException(ExcelImportEnum.IS_NOT_A_VALID_TEMPLATE);
                }
                int i = 0;
                for (String title : titlemap.values()) {
                    if (StringUtils.equals((CharSequence)title, (CharSequence)params.getImportFields()[i++])) continue;
                    LOGGER.error("excel\u5217\u987a\u5e8f\u4e0d\u4e00\u81f4");
                    throw new ExcelImportException(ExcelImportEnum.IS_NOT_A_VALID_TEMPLATE);
                }
            } else {
                int le = params.getImportFields().length;
                for (int i = 0; i < le; ++i) {
                    if (titlemap.containsValue(params.getImportFields()[i])) continue;
                    throw new ExcelImportException(ExcelImportEnum.IS_NOT_A_VALID_TEMPLATE);
                }
            }
        } else {
            Collection<ExcelImportEntity> collection = excelParams.values();
            for (ExcelImportEntity excelImportEntity : collection) {
                if (!excelImportEntity.isImportField() || titlemap.containsValue(excelImportEntity.getName())) continue;
                LOGGER.error(excelImportEntity.getName() + "\u5fc5\u987b\u6709,\u4f46\u662f\u6ca1\u627e\u5230");
                throw new ExcelImportException(ExcelImportEnum.IS_NOT_A_VALID_TEMPLATE);
            }
            int le = excelCollection.size();
            for (int i = 0; i < le; ++i) {
                ExcelCollectionParams collectionparams = excelCollection.get(i);
                collection = collectionparams.getExcelParams().values();
                for (ExcelImportEntity excelImportEntity : collection) {
                    if (!excelImportEntity.isImportField() || titlemap.containsValue(collectionparams.getExcelName() + "_" + excelImportEntity.getName())) continue;
                    throw new ExcelImportException(ExcelImportEnum.IS_NOT_A_VALID_TEMPLATE);
                }
            }
        }
    }

    public void saveFieldValue(ImportParams params, Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString, Row row) throws Exception {
        Object value = this.cellValueServer.getValue(params.getDataHandler(), object, cell, excelParams, titleString, params.getDictHandler());
        if (object instanceof Map) {
            if (params.getDataHandler() != null) {
                params.getDataHandler().setMapValue((Map)object, titleString, value);
            } else {
                ((Map)object).put(titleString, value);
            }
        } else {
            this.setValues(excelParams.get(titleString), object, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImage(Object object, String picId, Map<String, ExcelImportEntity> excelParams, String titleString, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        if (pictures == null) {
            return;
        }
        PictureData image = pictures.get(picId);
        if (image == null) {
            return;
        }
        byte[] data = image.getData();
        String fileName = "pic" + Math.round(Math.random() * 1.0E11);
        fileName = fileName + "." + PoiPublicUtil.getFileExtendName(data);
        if (excelParams.get(titleString).getSaveType() == 1) {
            String path = this.getSaveUrl(excelParams.get(titleString), object);
            File savefile = new File(path);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            savefile = new File(path + File.separator + fileName);
            FileOutputStream fos = new FileOutputStream(savefile);
            try {
                fos.write(data);
            }
            finally {
                IOUtils.closeQuietly((Closeable)fos);
            }
            this.setValues(excelParams.get(titleString), object, this.getSaveUrl(excelParams.get(titleString), object) + File.separator + fileName);
        } else {
            this.setValues(excelParams.get(titleString), object, data);
        }
    }

    private void createErrorCellStyle(Workbook workbook) {
        this.errorCellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setColor((short)10);
        this.errorCellStyle.setFont(font);
    }
}

