/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.SqlRunner;
import java.sql.SQLException;
import java.util.Collection;

public class ActiveEntity
extends Entity {
    private static final long serialVersionUID = 6112321379601134750L;
    private SqlRunner runner;

    public static ActiveEntity create() {
        return new ActiveEntity();
    }

    public static ActiveEntity create(String tableName) {
        return new ActiveEntity(tableName);
    }

    public static <T> ActiveEntity parse(T bean) {
        return ActiveEntity.create(null).parseBean((Object)bean);
    }

    public static <T> ActiveEntity parse(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return ActiveEntity.create(null).parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    public static <T> ActiveEntity parseWithUnderlineCase(T bean) {
        return ActiveEntity.create(null).parseBean((Object)bean, true, true);
    }

    public ActiveEntity() {
        this(SqlRunner.create(), (String)null);
    }

    public ActiveEntity(String tableName) {
        this(SqlRunner.create(), tableName);
    }

    public ActiveEntity(Entity entity) {
        this(SqlRunner.create(), entity);
    }

    public ActiveEntity(SqlRunner runner, String tableName) {
        super(tableName);
        this.runner = runner;
    }

    public ActiveEntity(SqlRunner runner, Entity entity) {
        super(entity.getTableName());
        this.putAll(entity);
        this.runner = runner;
    }

    @Override
    public ActiveEntity setTableName(String tableName) {
        return (ActiveEntity)super.setTableName(tableName);
    }

    @Override
    public ActiveEntity setFieldNames(Collection<String> fieldNames) {
        return (ActiveEntity)super.setFieldNames(fieldNames);
    }

    @Override
    public ActiveEntity setFieldNames(String ... fieldNames) {
        return (ActiveEntity)super.setFieldNames(fieldNames);
    }

    @Override
    public ActiveEntity addFieldNames(String ... fieldNames) {
        return (ActiveEntity)super.addFieldNames(fieldNames);
    }

    @Override
    public <T> ActiveEntity parseBean(T bean) {
        return (ActiveEntity)super.parseBean((Object)bean);
    }

    @Override
    public <T> ActiveEntity parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return (ActiveEntity)super.parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    @Override
    public ActiveEntity set(String field, Object value) {
        return (ActiveEntity)super.set(field, value);
    }

    @Override
    public ActiveEntity setIgnoreNull(String field, Object value) {
        return (ActiveEntity)super.setIgnoreNull(field, value);
    }

    @Override
    public ActiveEntity clone() {
        return (ActiveEntity)super.clone();
    }

    public ActiveEntity add() {
        try {
            this.runner.insert(this);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity load() {
        try {
            this.runner.get(this);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity del() {
        try {
            this.runner.del(this);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity update(String primaryKey) {
        try {
            this.runner.update(this, Entity.create().set(primaryKey, this.get(primaryKey)));
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }
}

