/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.DependencyException;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.CellDataType;
import cn.hutool.poi.exceptions.POIException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExcelSaxUtil {
    public static final char CELL_FILL_CHAR = '@';
    public static final int MAX_CELL_BIT = 3;

    public static Object getDataValue(CellDataType cellDataType, String value, SharedStringsTable sharedStringsTable, String numFmtString) {
        Object result;
        if (null == value) {
            return null;
        }
        if (null == cellDataType) {
            cellDataType = CellDataType.NULL;
        }
        switch (cellDataType) {
            case BOOL: {
                result = value.charAt(0) != '0';
                break;
            }
            case ERROR: {
                result = StrUtil.format((CharSequence)"\\\"ERROR: {} ", value);
                break;
            }
            case FORMULA: {
                result = StrUtil.format((CharSequence)"\"{}\"", value);
                break;
            }
            case INLINESTR: {
                result = new XSSFRichTextString(value).toString();
                break;
            }
            case SSTINDEX: {
                try {
                    int index = Integer.parseInt(value);
                    result = new XSSFRichTextString(sharedStringsTable.getEntryAt(index)).getString();
                }
                catch (NumberFormatException e) {
                    result = value;
                }
                break;
            }
            case NUMBER: {
                result = ExcelSaxUtil.getNumberValue(value, numFmtString);
                break;
            }
            case DATE: {
                try {
                    result = ExcelSaxUtil.getDateValue(value);
                }
                catch (Exception e) {
                    result = value;
                }
                break;
            }
            default: {
                result = value;
            }
        }
        return result;
    }

    public static String formatCellContent(String value, int numFmtIndex, String numFmtString) {
        if (null != numFmtString) {
            try {
                value = new DataFormatter().formatRawCellContents(Double.parseDouble(value), numFmtIndex, numFmtString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static int countNullCell(String preRef, String ref) {
        String preXfd = StrUtil.nullToDefault(preRef, "@").replaceAll("\\d+", "");
        String xfd = StrUtil.nullToDefault(ref, "@").replaceAll("\\d+", "");
        preXfd = StrUtil.fillBefore(preXfd, '@', 3);
        xfd = StrUtil.fillBefore(xfd, '@', 3);
        char[] preLetter = preXfd.toCharArray();
        char[] letter = xfd.toCharArray();
        int res = (letter[0] - preLetter[0]) * 26 * 26 + (letter[1] - preLetter[1]) * 26 + (letter[2] - preLetter[2]);
        return res - 1;
    }

    public static void readFrom(InputStream xmlDocStream, ContentHandler handler) throws DependencyException, POIException, IORuntimeException {
        XMLReader xmlReader;
        try {
            xmlReader = SAXHelper.newXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            if (e.getMessage().contains("org.apache.xerces.parsers.SAXParser")) {
                throw new DependencyException(e, "You need to add 'xerces:xercesImpl' to your project and version >= 2.11.0", new Object[0]);
            }
            throw new POIException(e);
        }
        xmlReader.setContentHandler(handler);
        try {
            xmlReader.parse(new InputSource(xmlDocStream));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (SAXException e) {
            throw new POIException(e);
        }
    }

    public static DateTime getDateValue(String value) {
        return ExcelSaxUtil.getDateValue(Double.parseDouble(value));
    }

    public static DateTime getDateValue(double value) {
        return DateUtil.date(org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)value, (boolean)false));
    }

    private static Number getNumberValue(String value, String numFmtString) {
        long longPart;
        if (StrUtil.isBlank(value)) {
            return null;
        }
        double numValue = Double.parseDouble(value);
        if (null != numFmtString && numFmtString.indexOf(46) < 0 && (double)(longPart = (long)numValue) == numValue) {
            return longPart;
        }
        return numValue;
    }
}

