/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.core.map.CaseInsensitiveLinkedMap;
import cn.hutool.core.map.CaseInsensitiveTreeMap;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    static Object testValidity(Object obj) throws JSONException {
        if (!ObjectUtil.isValidIfNumber((Object)obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
        return obj;
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null || value instanceof JSONNull) {
            return JSONNull.NULL.toString();
        }
        if (value instanceof JSONString) {
            try {
                return ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value instanceof Number) {
            return NumberUtil.toStr((Number)((Number)value));
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JSONObject(map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray(coll).toString();
        }
        if (ArrayUtil.isArray((Object)value)) {
            return new JSONArray(value).toString();
        }
        return JSONUtil.quote(value.toString());
    }

    public static Object stringToValue(String string) {
        if (StrUtil.isEmpty((CharSequence)string) || "null".equalsIgnoreCase(string)) {
            return JSONNull.NULL;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (StrUtil.containsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{".", "e"})) {
                    return new BigDecimal(string);
                }
                long myLong = Long.parseLong(string);
                if (string.equals(Long.toString(myLong))) {
                    if (myLong == (long)((int)myLong)) {
                        return (int)myLong;
                    }
                    return myLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static JSONObject propertyPut(JSONObject jsonObject, Object key, Object value, Filter<MutablePair<String, Object>> filter) {
        String[] path = StrUtil.splitToArray((CharSequence)Convert.toStr((Object)key), (char)'.');
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject(target.getConfig());
                target.setOnce(segment, nextTarget, filter);
            }
            target = nextTarget;
        }
        target.setOnce(path[last], value, filter);
        return jsonObject;
    }

    static boolean defaultIgnoreNullValue(Object obj) {
        return false == obj instanceof CharSequence && false == obj instanceof JSONTokener && false == obj instanceof Map;
    }

    static CopyOptions toCopyOptions(JSONConfig config) {
        return CopyOptions.create().setIgnoreCase(config.isIgnoreCase()).setIgnoreError(config.isIgnoreError()).setIgnoreNullValue(config.isIgnoreNullValue()).setTransientSupport(config.isTransientSupport());
    }

    static Map<String, Object> createRawMap(int capacity, JSONConfig config) {
        if (null == config) {
            config = JSONConfig.create();
        }
        Comparator<String> keyComparator = config.getKeyComparator();
        Object rawHashMap = config.isIgnoreCase() ? (null != keyComparator ? new CaseInsensitiveTreeMap(keyComparator) : new CaseInsensitiveLinkedMap(capacity)) : (null != keyComparator ? new TreeMap(keyComparator) : new LinkedHashMap(capacity));
        return rawHashMap;
    }
}

