/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.chatroom;

import io.rong.RongCloud;
import io.rong.methods.chatroom.ban.Ban;
import io.rong.methods.chatroom.block.Block;
import io.rong.methods.chatroom.demotion.Demotion;
import io.rong.methods.chatroom.distribute.Distribute;
import io.rong.methods.chatroom.gag.Gag;
import io.rong.methods.chatroom.keepalive.Keepalive;
import io.rong.methods.chatroom.mute.MuteMembers;
import io.rong.methods.chatroom.whitelist.Whitelist;
import io.rong.models.chatroom.ChatroomMember;
import io.rong.models.chatroom.ChatroomModel;
import io.rong.models.response.ChatroomUserQueryResult;
import io.rong.models.response.CheckChatRoomUserResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Chatroom {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "chatroom";
    private String appKey;
    private String appSecret;
    public Block block;
    public Gag gag;
    public MuteMembers muteMembers;
    public Ban ban;
    public Keepalive keepalive;
    public Demotion demotion;
    public Whitelist whiteList;
    public Distribute distribute;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
        this.gag.setRongCloud(rongCloud);
        this.keepalive.setRongCloud(rongCloud);
        this.demotion.setRongCloud(rongCloud);
        this.whiteList.setRongCloud(rongCloud);
        this.block.setRongCloud(rongCloud);
        this.demotion.setRongCloud(rongCloud);
        this.distribute.setRongCloud(rongCloud);
        this.ban.setRongCloud(rongCloud);
    }

    public Chatroom(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.gag = new Gag(appKey, appSecret);
        this.keepalive = new Keepalive(appKey, appSecret);
        this.demotion = new Demotion(appKey, appSecret);
        this.whiteList = new Whitelist(appKey, appSecret);
        this.block = new Block(appKey, appSecret);
        this.distribute = new Distribute(appKey, appSecret);
        this.ban = new Ban(appKey, appSecret);
        this.muteMembers = new MuteMembers(appKey, appSecret, rongCloud);
    }

    public ResponseResult create(ChatroomModel[] chatrooms) throws Exception {
        if (chatrooms == null) {
            return new ResponseResult(1002, "Paramer 'chatrooms' is required");
        }
        for (ChatroomModel chatroom : chatrooms) {
            String message = CommonUtil.checkFiled(chatroom, PATH, "create");
            if (null == message) continue;
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chatrooms.length; ++i) {
            ChatroomModel chatroom = chatrooms[i];
            sb.append("&chatroom[" + chatroom.getId() + "]=").append(URLEncoder.encode(chatroom.getName(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/create.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "create", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public ResponseResult destroy(ChatroomModel chatroom) throws Exception {
        String message = CommonUtil.checkFiled(chatroom, PATH, "destory");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroom.getId(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/destroy.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "destory", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public ChatroomUserQueryResult get(ChatroomModel chatroom) throws Exception {
        String message = CommonUtil.checkFiled(chatroom, PATH, "get");
        if (null != message) {
            return (ChatroomUserQueryResult)GsonUtil.fromJson(message, ChatroomUserQueryResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroom.getId().toString(), UTF8));
        sb.append("&count=").append(URLEncoder.encode(chatroom.getCount().toString(), UTF8));
        sb.append("&order=").append(URLEncoder.encode(chatroom.getOrder().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/user/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ChatroomUserQueryResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn)), ChatroomUserQueryResult.class);
    }

    public CheckChatRoomUserResult isExist(ChatroomMember member) throws Exception {
        String message = CommonUtil.checkFiled(member, PATH, "isExist");
        if (null != message) {
            return (CheckChatRoomUserResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(member.chatroomId.toString(), UTF8));
        sb.append("&userId=").append(URLEncoder.encode(member.id.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/user/exist.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CheckChatRoomUserResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "isExist", HttpUtil.returnResult(conn)), CheckChatRoomUserResult.class);
    }
}

