/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.DbType;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.proxy.jdbc.WrapperProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import java.lang.reflect.Field;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;

public final class DruidConnectionHolder {
    private static final Log LOG = LogFactory.getLog(DruidConnectionHolder.class);
    static volatile boolean ORACLE_SOCKET_FIELD_ERROR;
    static volatile Field ORACLE_FIELD_NET;
    static volatile Field ORACLE_FIELD_S_ATTS;
    static volatile Field ORACLE_FIELD_NT;
    static volatile Field ORACLE_FIELD_SOCKET;
    public static boolean holdabilityUnsupported;
    protected final DruidAbstractDataSource dataSource;
    protected final long connectionId;
    protected final Connection conn;
    protected final List<ConnectionEventListener> connectionEventListeners;
    protected final List<StatementEventListener> statementEventListeners;
    protected final long connectTimeMillis;
    protected volatile long lastActiveTimeMillis;
    protected volatile long lastExecTimeMillis;
    protected volatile long lastKeepTimeMillis;
    protected volatile long lastValidTimeMillis;
    protected long useCount;
    private long keepAliveCheckCount;
    private long lastNotEmptyWaitNanos;
    private final long createNanoSpan;
    protected PreparedStatementPool statementPool;
    protected final List<Statement> statementTrace;
    protected final boolean defaultReadOnly;
    protected final int defaultHoldability;
    protected final int defaultTransactionIsolation;
    protected final boolean defaultAutoCommit;
    protected boolean underlyingReadOnly;
    protected int underlyingHoldability;
    protected int underlyingTransactionIsolation;
    protected boolean underlyingAutoCommit;
    protected volatile boolean discard;
    protected volatile boolean active;
    protected final Map<String, Object> variables;
    protected final Map<String, Object> globalVariables;
    final ReentrantLock lock;
    protected String initSchema;
    protected Socket socket;

    public DruidConnectionHolder(DruidAbstractDataSource dataSource, DruidAbstractDataSource.PhysicalConnectionInfo pyConnectInfo) throws SQLException {
        this(dataSource, pyConnectInfo.getPhysicalConnection(), pyConnectInfo.getConnectNanoSpan(), pyConnectInfo.getVairiables(), pyConnectInfo.getGlobalVairiables());
    }

    public DruidConnectionHolder(DruidAbstractDataSource dataSource, Connection conn, long connectNanoSpan) throws SQLException {
        this(dataSource, conn, connectNanoSpan, null, null);
    }

    public DruidConnectionHolder(DruidAbstractDataSource dataSource, Connection conn, long connectNanoSpan, Map<String, Object> variables, Map<String, Object> globalVariables) throws SQLException {
        block16: {
            this.connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
            this.statementEventListeners = new CopyOnWriteArrayList<StatementEventListener>();
            this.statementTrace = new ArrayList<Statement>(2);
            this.lock = new ReentrantLock();
            this.dataSource = dataSource;
            this.conn = conn;
            this.createNanoSpan = connectNanoSpan;
            this.variables = variables;
            this.globalVariables = globalVariables;
            this.lastActiveTimeMillis = this.connectTimeMillis = System.currentTimeMillis();
            this.lastExecTimeMillis = this.connectTimeMillis;
            this.underlyingAutoCommit = conn.getAutoCommit();
            this.connectionId = conn instanceof WrapperProxy ? ((WrapperProxy)((Object)conn)).getId() : dataSource.createConnectionId();
            Class<?> conClass = conn.getClass();
            String connClassName = conClass.getName();
            if (!ORACLE_SOCKET_FIELD_ERROR && connClassName.equals("oracle.jdbc.driver.T4CConnection")) {
                try {
                    if (ORACLE_FIELD_NET == null) {
                        Field field = conClass.getDeclaredField("net");
                        field.setAccessible(true);
                        ORACLE_FIELD_NET = field;
                    }
                    Object net = ORACLE_FIELD_NET.get(conn);
                    if (ORACLE_FIELD_S_ATTS == null) {
                        Field field = net.getClass().getSuperclass().getDeclaredField("sAtts");
                        field.setAccessible(true);
                        ORACLE_FIELD_S_ATTS = field;
                    }
                    Object sAtts = ORACLE_FIELD_S_ATTS.get(net);
                    if (ORACLE_FIELD_NT == null) {
                        Field field = sAtts.getClass().getDeclaredField("nt");
                        field.setAccessible(true);
                        ORACLE_FIELD_NT = field;
                    }
                    Object nt = ORACLE_FIELD_NT.get(sAtts);
                    if (ORACLE_FIELD_SOCKET == null) {
                        Field field = nt.getClass().getDeclaredField("socket");
                        field.setAccessible(true);
                        ORACLE_FIELD_SOCKET = field;
                    }
                    this.socket = (Socket)ORACLE_FIELD_SOCKET.get(nt);
                }
                catch (Throwable ignored) {
                    ORACLE_SOCKET_FIELD_ERROR = true;
                }
            }
            boolean initUnderlyHoldability = !holdabilityUnsupported;
            DbType dbType = DbType.of(dataSource.dbTypeName);
            if (dbType == DbType.sybase || dbType == DbType.db2 || dbType == DbType.hive || dbType == DbType.odps) {
                initUnderlyHoldability = false;
            }
            if (initUnderlyHoldability) {
                try {
                    this.underlyingHoldability = conn.getHoldability();
                }
                catch (UnsupportedOperationException e) {
                    holdabilityUnsupported = true;
                    LOG.warn("getHoldability unsupported", e);
                }
                catch (SQLFeatureNotSupportedException e) {
                    holdabilityUnsupported = true;
                    LOG.warn("getHoldability unsupported", e);
                }
                catch (SQLException e) {
                    if ("Method not supported".equals(e.getMessage())) {
                        holdabilityUnsupported = true;
                    }
                    LOG.warn("getHoldability error", e);
                }
            }
            this.underlyingReadOnly = conn.isReadOnly();
            try {
                this.underlyingTransactionIsolation = conn.getTransactionIsolation();
            }
            catch (SQLException e) {
                if ("HY000".equals(e.getSQLState()) || "com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException".equals(e.getClass().getName())) break block16;
                throw e;
            }
        }
        this.defaultHoldability = this.underlyingHoldability;
        this.defaultTransactionIsolation = this.underlyingTransactionIsolation;
        this.defaultAutoCommit = this.underlyingAutoCommit;
        this.defaultReadOnly = this.underlyingReadOnly;
    }

    public long getConnectTimeMillis() {
        return this.connectTimeMillis;
    }

    public boolean isUnderlyingReadOnly() {
        return this.underlyingReadOnly;
    }

    public void setUnderlyingReadOnly(boolean underlyingReadOnly) {
        this.underlyingReadOnly = underlyingReadOnly;
    }

    public int getUnderlyingHoldability() {
        return this.underlyingHoldability;
    }

    public void setUnderlyingHoldability(int underlyingHoldability) {
        this.underlyingHoldability = underlyingHoldability;
    }

    public int getUnderlyingTransactionIsolation() {
        return this.underlyingTransactionIsolation;
    }

    public void setUnderlyingTransactionIsolation(int underlyingTransactionIsolation) {
        this.underlyingTransactionIsolation = underlyingTransactionIsolation;
    }

    public boolean isUnderlyingAutoCommit() {
        return this.underlyingAutoCommit;
    }

    public void setUnderlyingAutoCommit(boolean underlyingAutoCommit) {
        this.underlyingAutoCommit = underlyingAutoCommit;
    }

    public long getLastActiveTimeMillis() {
        return this.lastActiveTimeMillis;
    }

    public void setLastActiveTimeMillis(long lastActiveMillis) {
        this.lastActiveTimeMillis = lastActiveMillis;
    }

    public long getLastExecTimeMillis() {
        return this.lastExecTimeMillis;
    }

    public void setLastExecTimeMillis(long lastExecTimeMillis) {
        this.lastExecTimeMillis = lastExecTimeMillis;
    }

    public void addTrace(DruidPooledStatement stmt) {
        this.lock.lock();
        try {
            this.statementTrace.add(stmt);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeTrace(DruidPooledStatement stmt) {
        this.lock.lock();
        try {
            this.statementTrace.remove(stmt);
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ConnectionEventListener> getConnectionEventListeners() {
        return this.connectionEventListeners;
    }

    public List<StatementEventListener> getStatementEventListeners() {
        return this.statementEventListeners;
    }

    public PreparedStatementPool getStatementPool() {
        if (this.statementPool == null) {
            this.statementPool = new PreparedStatementPool(this);
        }
        return this.statementPool;
    }

    public PreparedStatementPool getStatementPoolDirect() {
        return this.statementPool;
    }

    public void clearStatementCache() {
        if (this.statementPool == null) {
            return;
        }
        this.statementPool.clear();
    }

    public DruidAbstractDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPoolPreparedStatements() {
        return this.dataSource.isPoolPreparedStatements();
    }

    public Connection getConnection() {
        return this.conn;
    }

    public long getTimeMillis() {
        return this.connectTimeMillis;
    }

    public long getUseCount() {
        return this.useCount;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public void incrementUseCount() {
        ++this.useCount;
    }

    public long getKeepAliveCheckCount() {
        return this.keepAliveCheckCount;
    }

    public void incrementKeepAliveCheckCount() {
        ++this.keepAliveCheckCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SQLException {
        if (this.underlyingReadOnly != this.defaultReadOnly) {
            this.conn.setReadOnly(this.defaultReadOnly);
            this.underlyingReadOnly = this.defaultReadOnly;
        }
        if (this.underlyingHoldability != this.defaultHoldability) {
            this.conn.setHoldability(this.defaultHoldability);
            this.underlyingHoldability = this.defaultHoldability;
        }
        if (this.underlyingTransactionIsolation != this.defaultTransactionIsolation) {
            this.conn.setTransactionIsolation(this.defaultTransactionIsolation);
            this.underlyingTransactionIsolation = this.defaultTransactionIsolation;
        }
        if (this.underlyingAutoCommit != this.defaultAutoCommit) {
            this.conn.setAutoCommit(this.defaultAutoCommit);
            this.underlyingAutoCommit = this.defaultAutoCommit;
        }
        this.connectionEventListeners.clear();
        this.statementEventListeners.clear();
        this.lock.lock();
        try {
            for (Object item : this.statementTrace.toArray()) {
                Statement stmt = (Statement)item;
                JdbcUtils.close(stmt);
            }
            this.statementTrace.clear();
        }
        finally {
            this.lock.unlock();
        }
        this.conn.clearWarnings();
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    public long getCreateNanoSpan() {
        return this.createNanoSpan;
    }

    public long getLastNotEmptyWaitNanos() {
        return this.lastNotEmptyWaitNanos;
    }

    protected void setLastNotEmptyWaitNanos(long lastNotEmptyWaitNanos) {
        this.lastNotEmptyWaitNanos = lastNotEmptyWaitNanos;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{ID:");
        buf.append(System.identityHashCode(this.conn));
        buf.append(", ConnectTime:\"");
        buf.append(Utils.toString(new Date(this.connectTimeMillis)));
        buf.append("\", UseCount:");
        buf.append(this.useCount);
        if (this.lastActiveTimeMillis > 0L) {
            buf.append(", LastActiveTime:\"");
            buf.append(Utils.toString(new Date(this.lastActiveTimeMillis)));
            buf.append("\"");
        }
        if (this.lastKeepTimeMillis > 0L) {
            buf.append(", LastKeepTimeMillis:\"");
            buf.append(Utils.toString(new Date(this.lastKeepTimeMillis)));
            buf.append("\"");
        }
        if (this.statementPool != null && this.statementPool.getMap().size() > 0) {
            buf.append("\", CachedStatementCount:");
            buf.append(this.statementPool.getMap().size());
        }
        buf.append("}");
        return buf.toString();
    }
}

