package darabonba.core.policy;

import com.aliyun.core.utils.Configuration;

import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class UserAgentPolicy {
    public static final String DEFAULT_USER_AGENT_HEADER = "AlibabaCloud";
    private static final String PLATFORM_INFO_FORMAT = "%s; %s; %s; %s";
    private static final int MAX_APP_ID_LENGTH = 50;
    private static String coreVersion = "unknown";

    static {
        try {
            Properties props = new Properties();
            props.load(UserAgentPolicy.class.getClassLoader().getResourceAsStream("core.properties"));
            coreVersion = props.getProperty("sdk.project.version");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String toUserAgentString(String serviceName) {
        return toUserAgentString(serviceName, new Configuration());
    }

    public static String toUserAgentString(String serviceName, Configuration configuration) {
        StringBuilder userAgentBuilder = new StringBuilder();

        userAgentBuilder.append(DEFAULT_USER_AGENT_HEADER)
                .append(" ")
                .append("TeaDSL Java Async")
                .append(" ")
                .append("CoreService")
                .append("/")
                .append(coreVersion);

        if (serviceName != null) {
            serviceName = serviceName.length() > MAX_APP_ID_LENGTH ? serviceName.substring(0, MAX_APP_ID_LENGTH)
                    : serviceName;
            userAgentBuilder.append(" ")
                    .append("alibabacloud-")
                    .append(serviceName.toLowerCase(Locale.ROOT));
        }

        userAgentBuilder.append(" ")
                .append("(")
                .append(getPlatformInfo())
                .append(")");

        return userAgentBuilder.toString();
    }

    private static String getPlatformInfo() {
        String javaVersion = Configuration.getGlobalConfiguration().get("java.version");
        String osName = Configuration.getGlobalConfiguration().get("os.name");
        String osVersion = Configuration.getGlobalConfiguration().get("os.version");
        String osArch = Configuration.getGlobalConfiguration().get("os.arch");

        return String.format(PLATFORM_INFO_FORMAT, javaVersion, osName, osVersion, osArch);
    }
}
