package darabonba.core.policy.retry.conditions;

import com.aliyun.core.utils.Validate;
import darabonba.core.policy.retry.RetryPolicyContext;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class AndRetryCondition implements RetryCondition {

    private final Set<RetryCondition> conditions = new LinkedHashSet<>();

    private AndRetryCondition(RetryCondition... conditions) {
        Collections.addAll(this.conditions, Validate.notEmpty(conditions, "%s cannot be empty.", "conditions"));
    }

    public static AndRetryCondition create(RetryCondition... conditions) {
        return new AndRetryCondition(conditions);
    }

    /**
     * @return True if all conditions are true, false otherwise.
     */
    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return conditions.stream().allMatch(r -> r.shouldRetry(context));
    }

    @Override
    public void requestWillNotBeRetried(RetryPolicyContext context) {
        conditions.forEach(c -> c.requestWillNotBeRetried(context));
    }
}
