package darabonba.core.policy.retry.conditions;

import darabonba.core.policy.retry.RetryPolicyContext;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;


public final class ExceptionsCondition implements RetryCondition {

    private final Set<Class<? extends Exception>> exceptionsToRetryOn;

    private ExceptionsCondition(Set<Class<? extends Exception>> exceptionsToRetryOn) {
        this.exceptionsToRetryOn = new HashSet<>(exceptionsToRetryOn);
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        Throwable exception = context.exception();
        if (exception == null) {
            return false;
        }
        Predicate<Class<? extends Exception>> isRetryableException =
                ex -> ex.isAssignableFrom(exception.getClass());

        Predicate<Class<? extends Exception>> hasRetrableCause =
                ex -> exception.getCause() != null && ex.isAssignableFrom(exception.getCause().getClass());
        return exceptionsToRetryOn.stream().anyMatch(isRetryableException.or(hasRetrableCause));
    }

    public static ExceptionsCondition create(Set<Class<? extends Exception>> exceptionsToRetryOn) {
        return new ExceptionsCondition(exceptionsToRetryOn);
    }

    public static ExceptionsCondition create(Class<? extends Exception>... exceptionsToRetryOn) {
        return new ExceptionsCondition(Arrays.stream(exceptionsToRetryOn).collect(Collectors.toSet()));
    }
}
