/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class FileUseMapEntry<T> {
    public static final Comparator<FileUseMapEntry<?>> COMPARE_BY_START = (o1, o2) -> Ints.saturatedCast((long)(o1.getStart() - o2.getStart()));
    public static final Comparator<FileUseMapEntry<?>> COMPARE_BY_SIZE = (o1, o2) -> Ints.saturatedCast((long)(o1.getSize() - o2.getSize()));
    private final long mStart;
    private final long mEnd;
    @Nullable
    private final T mStore;

    private FileUseMapEntry(long start, long end, @Nullable T store) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start < 0");
        Preconditions.checkArgument((end > start ? 1 : 0) != 0, (Object)"end <= start");
        this.mStart = start;
        this.mEnd = end;
        this.mStore = store;
    }

    public static FileUseMapEntry<Object> makeFree(long start, long end) {
        return new FileUseMapEntry<Object>(start, end, null);
    }

    public static <T> FileUseMapEntry<T> makeUsed(long start, long end, @Nonnull T store) {
        Preconditions.checkNotNull(store, (Object)"store == null");
        return new FileUseMapEntry<T>(start, end, store);
    }

    long getStart() {
        return this.mStart;
    }

    long getEnd() {
        return this.mEnd;
    }

    long getSize() {
        return this.mEnd - this.mStart;
    }

    boolean isFree() {
        return this.mStore == null;
    }

    @Nullable
    T getStore() {
        return this.mStore;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("start", this.mStart).add("end", this.mEnd).add("store", this.mStore).toString();
    }
}

