/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v1;

import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.builder.internal.aapt.AbstractProcessExecutionAapt;
import com.android.builder.model.AaptOptions;
import com.android.builder.png.QueuedCruncher;
import com.android.ide.common.internal.PngException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.QueueableResourceCompiler;
import com.android.repository.Revision;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AaptV1
extends AbstractProcessExecutionAapt
implements QueueableResourceCompiler {
    private static final long AUTO_THREAD_SHUTDOWN_MS = 250L;
    public static final Revision VERSION_FOR_SERVER_AAPT = new Revision(22, 0, 1);
    private final BuildToolInfo mBuildToolInfo;
    private final QueuedCruncher mCruncher;
    private final Executor mWaitExecutor;
    private final PngProcessMode mProcessMode;
    int key;

    public AaptV1(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, BuildToolInfo buildToolInfo, ILogger logger, PngProcessMode processMode, int cruncherProcesses) {
        super(processExecutor, processOutputHandler);
        this.mBuildToolInfo = buildToolInfo;
        this.mWaitExecutor = new ThreadPoolExecutor(0, 1, 250L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.mProcessMode = processMode;
        this.mCruncher = QueuedCruncher.Builder.INSTANCE.newCruncher(this.getAaptExecutablePath(), logger, cruncherProcesses);
    }

    @Override
    protected ProcessInfoBuilder makePackageProcessBuilder(AaptPackageConfig config) throws AaptException {
        List additionalParameters;
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getAaptExecutablePath());
        builder.addArgs("package");
        if (config.isVerbose()) {
            builder.addArgs("-v");
        }
        builder.addArgs("-f");
        builder.addArgs("--no-crunch");
        IAndroidTarget target = config.getAndroidTarget();
        Preconditions.checkNotNull((Object)target);
        builder.addArgs("-I", target.getPath(1));
        File manifestFile = config.getManifestFile();
        Preconditions.checkNotNull((Object)manifestFile);
        builder.addArgs("-M", FileUtils.toExportableSystemDependentPath((File)manifestFile));
        if (config.getResourceDir() != null) {
            builder.addArgs("-S", config.getResourceDir().getAbsolutePath());
        }
        if (config.getSourceOutputDir() != null) {
            builder.addArgs("-m");
            builder.addArgs("-J", FileUtils.toExportableSystemDependentPath((File)config.getSourceOutputDir()));
        }
        if (config.getResourceOutputApk() != null) {
            builder.addArgs("-F", config.getResourceOutputApk().getAbsolutePath());
        }
        if (config.getProguardOutputFile() != null) {
            builder.addArgs("-G", FileUtils.toExportableSystemDependentPath((File)config.getProguardOutputFile()));
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            builder.addArgs("-D", FileUtils.toExportableSystemDependentPath((File)config.getMainDexListProguardOutputFile()));
        }
        if (config.getSplits() != null) {
            for (String split : config.getSplits()) {
                builder.addArgs("--split", split);
            }
        }
        if (config.isDebuggable()) {
            builder.addArgs("--debug-mode");
        }
        ILogger logger = config.getLogger();
        Preconditions.checkNotNull((Object)logger);
        if (config.getVariantType() != VariantType.ANDROID_TEST && config.getCustomPackageForR() != null) {
            builder.addArgs("--custom-package", config.getCustomPackageForR());
            logger.verbose("Custom package for R class: '%s'", new Object[]{config.getCustomPackageForR()});
        }
        if (config.isPseudoLocalize()) {
            builder.addArgs("--pseudo-localize");
        }
        boolean generateFinalIds = true;
        if (config.getVariantType() == VariantType.LIBRARY) {
            generateFinalIds = false;
        } else if (config.getVariantType() == VariantType.ATOM && config.getBaseFeature() != null) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.addArgs("--non-constant-id");
        }
        AaptOptions options = config.getOptions();
        Preconditions.checkNotNull((Object)options);
        String ignoreAssets = options.getIgnoreAssets();
        if (ignoreAssets != null) {
            builder.addArgs("--ignore-assets", ignoreAssets);
        }
        if (config.getOptions().getFailOnMissingConfigEntry()) {
            builder.addArgs("--error-on-missing-config-entry");
        }
        builder.addArgs("-0", "apk");
        Collection noCompressList = config.getOptions().getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                builder.addArgs("-0", noCompress);
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addArgs(additionalParameters);
        }
        ArrayList<String> resourceConfigs = new ArrayList<String>();
        resourceConfigs.addAll(config.getResourceConfigs());
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        String preferredDensity = config.getPreferredDensity();
        if (preferredDensity != null && !densityResourceConfigs.isEmpty()) {
            throw new AaptException(String.format("When using splits, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)), new Object[0]);
        }
        if (densityResourceConfigs.size() > 1) {
            throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.", new Object[0]);
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.addArgs("-c", joiner.join((Iterable)otherResourceConfigs));
        }
        if (preferredDensity != null) {
            builder.addArgs("--preferred-density", preferredDensity);
        }
        if (!(config.getSymbolOutputDir() == null || config.getVariantType() != VariantType.LIBRARY && config.getLibraries().isEmpty())) {
            builder.addArgs("--output-text-symbols", FileUtils.toExportableSystemDependentPath((File)config.getSymbolOutputDir()));
        }
        builder.addArgs("--no-version-vectors");
        if (config.getBaseFeature() != null) {
            builder.addArgs("--feature-of", config.getBaseFeature().getAbsolutePath());
            for (File previousFeature : config.getPreviousFeatures()) {
                builder.addArgs("--feature-after", previousFeature.getAbsolutePath());
            }
        }
        return builder;
    }

    public void start() {
        if (this.mCruncher != null) {
            this.key = this.mCruncher.start();
        }
    }

    public void end() throws InterruptedException {
        if (this.mCruncher != null && this.key != -1) {
            this.mCruncher.end(this.key);
        }
    }

    @Override
    public ListenableFuture<File> compile(File file, File output) throws AaptException {
        ListenableFuture<File> futureResult;
        if (ResourceFolderType.getFolderType((String)file.getParentFile().getName()) == ResourceFolderType.RAW) {
            return Futures.immediateFuture(null);
        }
        if (this.mCruncher == null) {
            return super.compile(file, output);
        }
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)output.isDirectory(), (Object)"!output.isDirectory()");
        SettableFuture actualResult = SettableFuture.create();
        if (!this.mProcessMode.shouldProcess(file)) {
            actualResult.set(null);
            return actualResult;
        }
        File outputFile = AaptV1.compileOutputFor(file, output);
        try {
            Files.createParentDirs((File)outputFile);
        }
        catch (IOException e) {
            throw new AaptException(e, String.format("Failed to create parent directories for file '%s'", output.getAbsolutePath()), new Object[0]);
        }
        try {
            futureResult = this.mCruncher.crunchPng(this.key, file, outputFile);
        }
        catch (PngException e) {
            throw new AaptException(e, String.format("Failed to crunch file '%s' into '%s'", file.getAbsolutePath(), outputFile.getAbsolutePath()), new Object[0]);
        }
        futureResult.addListener(() -> {
            File result;
            try {
                result = (File)futureResult.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                actualResult.setException((Throwable)e);
                return;
            }
            catch (ExecutionException e) {
                actualResult.setException((Throwable)e);
                return;
            }
            if (file.getName().endsWith(".9.png")) {
                actualResult.set((Object)result);
                return;
            }
            if (result != null && file.length() < result.length()) {
                try {
                    Files.copy((File)file, (File)result);
                }
                catch (IOException e) {
                    actualResult.setException((Throwable)e);
                    return;
                }
            }
            actualResult.set((Object)result);
        }, this.mWaitExecutor);
        return actualResult;
    }

    @Override
    protected AbstractProcessExecutionAapt.CompileInvocation makeCompileProcessBuilder(File file, File output) throws AaptException {
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)output.isDirectory(), (Object)"!directory.isDirectory()");
        if (!file.getName().endsWith(".png")) {
            return null;
        }
        if (!this.mProcessMode.shouldProcess(file)) {
            return null;
        }
        File outputFile = AaptV1.compileOutputFor(file, output);
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getAaptExecutablePath());
        builder.addArgs("singleCrunch");
        builder.addArgs("-i", file.getAbsolutePath());
        builder.addArgs("-o", outputFile.getAbsolutePath());
        return new AbstractProcessExecutionAapt.CompileInvocation(builder, outputFile);
    }

    private static File compileOutputFor(File file, File output) {
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)output.isDirectory(), (Object)"!output.isDirectory()");
        File parentDir = new File(output, file.getParentFile().getName());
        FileUtils.mkdirs((File)parentDir);
        return new File(parentDir, file.getName());
    }

    private String getAaptExecutablePath() {
        String aapt = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing on '" + aapt + "'");
        }
        return aapt;
    }

    public static enum PngProcessMode {
        ALL{

            @Override
            public boolean shouldProcess(File file) {
                return file.getName().endsWith(".png");
            }
        }
        ,
        NO_CRUNCH{

            @Override
            public boolean shouldProcess(File file) {
                return file.getName().endsWith(".9.png");
            }
        };


        public abstract boolean shouldProcess(File var1);
    }
}

