/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.builder.tasks.BooleanLatch;
import com.android.builder.tasks.Job;
import com.android.ide.common.process.ProcessException;
import com.android.utils.FileUtils;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AaptProcess {
    private static final int DEFAULT_SLAVE_AAPT_TIMEOUT_IN_SECONDS = 5;
    private static final int SLAVE_AAPT_TIMEOUT_IN_SECONDS = System.getenv("SLAVE_AAPT_TIMEOUT") == null ? 5 : Integer.parseInt(System.getenv("SLAVE_AAPT_TIMEOUT"));
    private final String mAaptLocation;
    private final Process mProcess;
    private final ILogger mLogger;
    private final ProcessOutputFacade mProcessOutputFacade = new ProcessOutputFacade();
    private final List<String> mMessages = new ArrayList<String>();
    private final AtomicBoolean mReady = new AtomicBoolean(false);
    private final BooleanLatch mReadyLatch = new BooleanLatch();
    private final OutputStreamWriter mWriter;

    private AaptProcess(String aaptLocation, Process process, ILogger iLogger) throws InterruptedException {
        this.mAaptLocation = aaptLocation;
        this.mProcess = process;
        this.mLogger = iLogger;
        GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)this.mProcessOutputFacade);
        this.mWriter = new OutputStreamWriter(this.mProcess.getOutputStream());
    }

    public void crunch(File in, File out, Job<AaptProcess> job) throws IOException {
        this.mLogger.verbose("Process(%1$d) %2$s job:%3$s", new Object[]{this.hashCode(), in.getName(), job.toString()});
        if (!this.mReady.get()) {
            throw new RuntimeException("AAPT process not ready to receive commands");
        }
        NotifierProcessOutput notifier = new NotifierProcessOutput(job, this.mProcessOutputFacade, this.mLogger);
        this.mLogger.verbose("Process(%1$d) length = %2$d:%3$d", new Object[]{this.hashCode(), in.getAbsolutePath().length(), out.getAbsolutePath().length()});
        this.mProcessOutputFacade.setNotifier(notifier);
        this.mWriter.write("s\n");
        this.mWriter.write(FileUtils.toExportableSystemDependentPath((File)in));
        this.mWriter.write("\n");
        this.mWriter.write(FileUtils.toExportableSystemDependentPath((File)out));
        this.mWriter.write("\n");
        this.mWriter.flush();
        this.mLogger.verbose("Processed(%1$d) %2$s job:%3$s", new Object[]{this.hashCode(), in.getName(), job.toString()});
        this.mMessages.add(String.format("Process(%1$d) processed %2$s, job: %3$s", this.hashCode(), in.getName(), job.toString()));
    }

    public void waitForReady() throws InterruptedException {
        if (!this.mReadyLatch.await(TimeUnit.NANOSECONDS.convert(SLAVE_AAPT_TIMEOUT_IN_SECONDS, TimeUnit.SECONDS))) {
            throw new RuntimeException(String.format("Timed out while waiting for slave aapt process, make sure the aapt execute at %1$s can run successfully (some anti-virus may block it) or try setting environment variable SLAVE_AAPT_TIMEOUT to a value bigger than %2$d seconds", this.mAaptLocation, SLAVE_AAPT_TIMEOUT_IN_SECONDS));
        }
        if (this.mReady.get()) {
            this.mLogger.verbose("Slave %1$s is ready", new Object[]{this.hashCode()});
        } else {
            this.mLogger.verbose("Slave %1$s failed to start", new Object[]{this.hashCode()});
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashcode", this.hashCode()).add("\nlocation", (Object)this.mAaptLocation).add("\nready", this.mReady.get()).add("\nprocess", this.mProcess.hashCode()).toString();
    }

    public void shutdown() throws IOException, InterruptedException {
        this.mReady.set(false);
        this.mWriter.write("quit\n");
        this.mWriter.flush();
        this.mProcess.waitFor();
        this.mLogger.verbose("Process (%1$s) processed %2$s files", new Object[]{this.hashCode(), this.mMessages.size()});
        for (String message : this.mMessages) {
            this.mLogger.verbose(message, new Object[0]);
        }
    }

    private static class NotifierProcessOutput
    implements GrabProcessOutput.IProcessOutput {
        private final Job<AaptProcess> mJob;
        private final ProcessOutputFacade mOwner;
        private final ILogger mLogger;
        private final AtomicBoolean mInError = new AtomicBoolean(false);
        private final StringBuilder mErrorBuilder = new StringBuilder();

        NotifierProcessOutput(Job<AaptProcess> job, ProcessOutputFacade owner, ILogger iLogger) {
            this.mOwner = owner;
            this.mJob = job;
            this.mLogger = iLogger;
        }

        public void out(String line) {
            if (line != null) {
                this.mLogger.verbose("AAPT notify(%1$s): %2$s", new Object[]{this.mJob, line});
                if (line.equalsIgnoreCase("Done")) {
                    this.mOwner.reset();
                    if (this.mInError.get()) {
                        this.mLogger.verbose("Job is in error mode, cause : %1$s", new Object[]{this.mErrorBuilder.toString()});
                        this.mJob.error((Exception)((Object)new ProcessException(this.mErrorBuilder.toString())));
                    } else {
                        this.mJob.finished();
                    }
                } else if (line.equalsIgnoreCase("Error")) {
                    this.mInError.set(true);
                } else {
                    this.mLogger.verbose("AAPT(%1$s) discarded: %2$s", new Object[]{this.mJob, line});
                }
            }
        }

        public void err(String line) {
            if (line != null) {
                if (this.mInError.get()) {
                    this.mErrorBuilder.append(line);
                }
                this.mLogger.verbose("AAPT warning(%1$s), Job(%2$s): %3$s", new Object[]{this.mOwner.getProcess().hashCode(), this.mJob, line});
                this.mLogger.warning("AAPT: %1$s", new Object[]{line});
            }
        }
    }

    private class ProcessOutputFacade
    implements GrabProcessOutput.IProcessOutput {
        NotifierProcessOutput notifier = null;

        private ProcessOutputFacade() {
        }

        synchronized void setNotifier(NotifierProcessOutput notifierProcessOutput) {
            if (this.notifier != null) {
                throw new RuntimeException("Notifier already set, threading issue");
            }
            this.notifier = notifierProcessOutput;
        }

        public String toString() {
            return "Facade for " + String.valueOf(AaptProcess.this.hashCode());
        }

        synchronized void reset() {
            this.notifier = null;
        }

        synchronized NotifierProcessOutput getNotifier() {
            return this.notifier;
        }

        public synchronized void out(String line) {
            if (Strings.isNullOrEmpty((String)line)) {
                return;
            }
            if (line.equals("Ready")) {
                AaptProcess.this.mReady.set(true);
                AaptProcess.this.mReadyLatch.signal();
                return;
            }
            NotifierProcessOutput delegate = this.getNotifier();
            AaptProcess.this.mLogger.verbose("AAPT out(%1$s): %2$s", new Object[]{this.toString(), line});
            if (delegate != null) {
                AaptProcess.this.mLogger.verbose("AAPT out(%1$s): -> %2$s", new Object[]{this.toString(), delegate.mJob});
                delegate.out(line);
            } else {
                AaptProcess.this.mLogger.error(null, "AAPT out(%1$s) : No Delegate set : lost message:%2$s", new Object[]{this.toString(), line});
            }
        }

        public synchronized void err(String line) {
            if (Strings.isNullOrEmpty((String)line)) {
                return;
            }
            NotifierProcessOutput delegate = this.getNotifier();
            if (delegate != null) {
                AaptProcess.this.mLogger.verbose("AAPT1 err(%1$s): %2$s -> %3$s", new Object[]{this.toString(), line, delegate.mJob});
                delegate.err(line);
            } else if (!AaptProcess.this.mReady.get()) {
                if (line.equals("ERROR: Unknown command 'm'")) {
                    throw new RuntimeException("Invalid aapt version, version 21 or above is required");
                }
                AaptProcess.this.mLogger.verbose("AAPT err(%1$s): %2$s", new Object[]{this.toString(), line});
                AaptProcess.this.mLogger.error(null, "AAPT err(%1$s): %2$s", new Object[]{this.toString(), line});
            } else {
                AaptProcess.this.mLogger.error(null, "AAPT err(%1$s) : No Delegate set : lost message:%2$s", new Object[]{this.toString(), line});
            }
            if (!AaptProcess.this.mReadyLatch.isSignalled()) {
                AaptProcess.this.mReady.set(false);
                AaptProcess.this.mReadyLatch.signal();
            }
        }

        Process getProcess() {
            return AaptProcess.this.mProcess;
        }
    }

    public static class Builder {
        private final String mAaptLocation;
        private final ILogger mLogger;

        public Builder(String aaptPath, ILogger iLogger) {
            this.mAaptLocation = aaptPath;
            this.mLogger = iLogger;
        }

        public AaptProcess start() throws IOException, InterruptedException {
            String[] command = new String[]{this.mAaptLocation, "m"};
            this.mLogger.verbose("Trying to start %1$s", new Object[]{command[0]});
            Process process = new ProcessBuilder(command).start();
            AaptProcess aaptProcess = new AaptProcess(this.mAaptLocation, process, this.mLogger);
            this.mLogger.verbose("Started %1$d", new Object[]{aaptProcess.hashCode()});
            return aaptProcess;
        }
    }
}

