/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public abstract class MethodSignatureBase
implements MethodSignature {
    private final PsiSubstitutor mySubstitutor;
    private final PsiType[] myParameterTypes;
    protected final PsiTypeParameter[] myTypeParameters;

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameters) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        this.mySubstitutor = substitutor;
        assert (substitutor.isValid());
        this.myParameterTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiType type = parameterTypes[i];
            if (type != null) {
                PsiUtil.ensureValidType(type);
            }
            if (type instanceof PsiEllipsisType) {
                type = ((PsiEllipsisType)type).toArrayType();
            }
            this.myParameterTypes[i] = substitutor.substitute(type);
        }
        this.myTypeParameters = typeParameters;
    }

    @Override
    @NotNull
    public PsiType[] getParameterTypes() {
        if (this.myParameterTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBase", "getParameterTypes"));
        }
        return this.myParameterTypes;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBase", "getTypeParameters"));
        }
        return this.myTypeParameters;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBase", "getSubstitutor"));
        }
        return psiSubstitutor;
    }
}

