/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.SignatureGenerationException;
import com.auth0.jwt.impl.ClaimsHolder;
import com.auth0.jwt.impl.PayloadSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public final class JWTCreator {
    private final Algorithm algorithm;
    private final String headerJson;
    private final String payloadJson;

    private JWTCreator(Algorithm algorithm, Map<String, Object> headerClaims, Map<String, Object> payloadClaims) throws JWTCreationException {
        this.algorithm = algorithm;
        try {
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            module.addSerializer(ClaimsHolder.class, (JsonSerializer)new PayloadSerializer());
            mapper.registerModule((Module)module);
            mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.headerJson = mapper.writeValueAsString(headerClaims);
            this.payloadJson = mapper.writeValueAsString((Object)new ClaimsHolder(payloadClaims));
        }
        catch (JsonProcessingException e) {
            throw new JWTCreationException("Some of the Claims couldn't be converted to a valid JSON format.", e);
        }
    }

    static Builder init() {
        return new Builder();
    }

    private String sign() throws SignatureGenerationException {
        String header = Base64.encodeBase64URLSafeString((byte[])this.headerJson.getBytes(StandardCharsets.UTF_8));
        String payload = Base64.encodeBase64URLSafeString((byte[])this.payloadJson.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = this.algorithm.sign(header.getBytes(StandardCharsets.UTF_8), payload.getBytes(StandardCharsets.UTF_8));
        String signature = Base64.encodeBase64URLSafeString((byte[])signatureBytes);
        return String.format("%s.%s.%s", header, payload, signature);
    }

    public static class Builder {
        private final Map<String, Object> payloadClaims = new HashMap<String, Object>();
        private Map<String, Object> headerClaims = new HashMap<String, Object>();

        Builder() {
        }

        public Builder withHeader(Map<String, Object> headerClaims) {
            if (headerClaims == null) {
                return this;
            }
            for (Map.Entry<String, Object> entry : headerClaims.entrySet()) {
                if (entry.getValue() == null) {
                    this.headerClaims.remove(entry.getKey());
                    continue;
                }
                this.headerClaims.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder withKeyId(String keyId) {
            this.headerClaims.put("kid", keyId);
            return this;
        }

        public Builder withIssuer(String issuer) {
            this.addClaim("iss", issuer);
            return this;
        }

        public Builder withSubject(String subject) {
            this.addClaim("sub", subject);
            return this;
        }

        public Builder withAudience(String ... audience) {
            this.addClaim("aud", audience);
            return this;
        }

        public Builder withExpiresAt(Date expiresAt) {
            this.addClaim("exp", expiresAt);
            return this;
        }

        public Builder withNotBefore(Date notBefore) {
            this.addClaim("nbf", notBefore);
            return this;
        }

        public Builder withIssuedAt(Date issuedAt) {
            this.addClaim("iat", issuedAt);
            return this;
        }

        public Builder withJWTId(String jwtId) {
            this.addClaim("jti", jwtId);
            return this;
        }

        public Builder withClaim(String name, Boolean value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, value);
            return this;
        }

        public Builder withClaim(String name, Integer value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, value);
            return this;
        }

        public Builder withClaim(String name, Long value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, value);
            return this;
        }

        public Builder withClaim(String name, Double value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, value);
            return this;
        }

        public Builder withClaim(String name, String value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, value);
            return this;
        }

        public Builder withClaim(String name, Date value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, value);
            return this;
        }

        public Builder withArrayClaim(String name, String[] items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, items);
            return this;
        }

        public Builder withArrayClaim(String name, Integer[] items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, items);
            return this;
        }

        public Builder withArrayClaim(String name, Long[] items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addClaim(name, items);
            return this;
        }

        public String sign(Algorithm algorithm) throws IllegalArgumentException, JWTCreationException {
            if (algorithm == null) {
                throw new IllegalArgumentException("The Algorithm cannot be null.");
            }
            this.headerClaims.put("alg", algorithm.getName());
            this.headerClaims.put("typ", "JWT");
            String signingKeyId = algorithm.getSigningKeyId();
            if (signingKeyId != null) {
                this.withKeyId(signingKeyId);
            }
            return new JWTCreator(algorithm, this.headerClaims, this.payloadClaims).sign();
        }

        private void assertNonNull(String name) {
            if (name == null) {
                throw new IllegalArgumentException("The Custom Claim's name can't be null.");
            }
        }

        private void addClaim(String name, Object value) {
            if (value == null) {
                this.payloadClaims.remove(name);
                return;
            }
            this.payloadClaims.put(name, value);
        }
    }
}

