/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.demo;

import com.chinanetcenter.api.entity.PutPolicy;
import com.chinanetcenter.api.entity.SliceUploadHttpResult;
import com.chinanetcenter.api.exception.WsClientException;
import com.chinanetcenter.api.sliceUpload.BaseBlockUtil;
import com.chinanetcenter.api.sliceUpload.JSONObjectRet;
import com.chinanetcenter.api.util.Config;
import com.chinanetcenter.api.util.DateUtil;
import com.chinanetcenter.api.util.EncodeUtils;
import com.chinanetcenter.api.util.WetagUtil;
import com.chinanetcenter.api.wsbox.SliceUploadResumable;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;

public class SliceUploadDemo {
    public static void main(String[] args) throws FileNotFoundException {
        Config.AK = "your-ak";
        Config.SK = "your-sk";
        Config.PUT_URL = "your uploadDomain";
        String bucketName = "your-bucket";
        String fileKey = "java-sdk/com.toycloud.MeiYe.apk";
        String srcFilePath = "D:\\testfile\\test001\\com.toycloud.MeiYe.apk";
        BaseBlockUtil.CHUNK_SIZE = 0x400000;
        SliceUploadDemo demo = new SliceUploadDemo();
        demo.sliceUpload(bucketName, fileKey, srcFilePath);
    }

    public void sliceUpload(String bucketName, String fileKey, String filePath) {
        PutPolicy putPolicy = new PutPolicy();
        putPolicy.setScope(bucketName + ":" + fileKey);
        putPolicy.setOverwrite(1);
        putPolicy.setDeadline(String.valueOf(DateUtil.nextDate(1, new Date()).getTime()));
        JSONObjectRet jsonObjectRet = this.getJSONObjectRet(bucketName, fileKey, filePath);
        SliceUploadResumable sliceUploadResumable = new SliceUploadResumable();
        sliceUploadResumable.execUpload(bucketName, fileKey, filePath, putPolicy, null, jsonObjectRet);
    }

    public void sliceUpload(String bucketName, String fileKey, String filePath, String mimeType) {
        PutPolicy putPolicy = new PutPolicy();
        putPolicy.setScope(bucketName);
        putPolicy.setOverwrite(1);
        putPolicy.setDeadline(String.valueOf(DateUtil.nextDate(1, new Date()).getTime()));
        JSONObjectRet jsonObjectRet = this.getJSONObjectRet(bucketName, fileKey, filePath);
        SliceUploadResumable sliceUploadResumable = new SliceUploadResumable();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("mimeType", mimeType);
        headMap.put("key", EncodeUtils.urlsafeEncode(fileKey));
        sliceUploadResumable.execUpload(bucketName, fileKey, filePath, putPolicy, null, jsonObjectRet, headMap);
    }

    public JSONObjectRet getJSONObjectRet(final String bucketName, final String fileKey, final String filePath) {
        return new JSONObjectRet(){

            @Override
            public void onSuccess(JsonNode obj) {
                SliceUploadHttpResult result;
                File fileHash = new File(filePath);
                String eTagHash = WetagUtil.getEtagHash(fileHash.getParent(), fileHash.getName());
                if (eTagHash.equals((result = new SliceUploadHttpResult(obj)).getHash())) {
                    System.out.println("\u4e0a\u4f20\u6210\u529f");
                } else {
                    System.out.println("hash not equal,eTagHash:" + eTagHash + " ,hash:" + result.getHash());
                }
            }

            @Override
            public void onSuccess(byte[] body) {
                System.out.println(new String(body));
            }

            @Override
            public void onFailure(Exception ex) {
                if (ex instanceof WsClientException) {
                    WsClientException wsClientException = (WsClientException)ex;
                    System.out.println(wsClientException.code + ":" + wsClientException.getMessage());
                } else {
                    ex.printStackTrace();
                }
                System.out.println("\u4e0a\u4f20\u51fa\u9519\uff0c" + ex.getMessage());
            }

            @Override
            public void onProcess(long current, long total) {
                System.out.printf("%s\r", current * 100L / total + " %");
            }

            @Override
            public void onPersist(JsonNode obj) {
                BaseBlockUtil.savePutExtra(bucketName, fileKey, obj);
            }
        };
    }
}

