/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.entity;

import com.chinanetcenter.api.entity.JsonValidator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class HttpClientResult {
    public String url;
    public int status;
    public String response;
    public JsonNode responseObject;
    private String innerResponse;

    public HttpClientResult() {
    }

    public HttpClientResult(int status) {
        this.status = status;
    }

    public HttpClientResult(int status, String response) {
        this.status = status;
        this.innerResponse = response;
        this.response = response;
        try {
            JsonNode innerJsonObject;
            ObjectMapper objectMapper;
            JsonNode jsonObject;
            if (new JsonValidator().validate(response) && (jsonObject = (objectMapper = new ObjectMapper()).readTree((innerJsonObject = objectMapper.readTree(this.innerResponse)).path("response").asText())) != null) {
                this.response = jsonObject.toString();
                this.responseObject = jsonObject;
            }
        }
        catch (Exception e) {
            this.response = this.innerResponse;
        }
    }

    public HttpClientResult(String url, int status, String response) {
        this(status, response);
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getInnerResponse() {
        return this.innerResponse;
    }

    public void setInnerResponse(String innerResponse) {
        this.innerResponse = innerResponse;
    }

    public JsonNode getResponseObject() {
        return this.responseObject;
    }

    public void setResponseObject(JsonNode responseObject) {
        this.responseObject = responseObject;
    }

    public String toString() {
        return "HttpClientResult{url=" + this.url + ",status=" + this.status + ", response='" + this.response + '}';
    }
}

