/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.sliceUpload;

import com.chinanetcenter.api.sliceUpload.BaseBlockUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.RandomAccessFile;

public class BlockObject {
    public RandomAccessFile file;
    private String bucketName;
    private String fileKey;
    private int blockIdx;
    private long start;
    private long offset;
    private int blockLen;
    private String lastCtx;
    private String token;
    private long successLength;

    public BlockObject(RandomAccessFile file, String bucketName, String fileKey, int blockIdx, int blockLen) {
        this.file = file;
        this.bucketName = bucketName;
        this.fileKey = fileKey;
        this.blockIdx = blockIdx;
        this.start = 0L;
        this.offset = (long)BaseBlockUtil.BLOCK_SIZE * (long)blockIdx;
        this.blockLen = blockLen;
    }

    public BlockObject(JsonNode obj) {
        this.parse(obj);
    }

    public void setCommonParam(RandomAccessFile file, String bucketName, String fileKey) {
        this.file = file;
        this.bucketName = bucketName;
        this.fileKey = fileKey;
    }

    public BlockObject parse(JsonNode obj) {
        this.blockIdx = obj.path("blockIdx").asInt(0);
        this.start = obj.path("start").asLong(0L);
        this.offset = obj.path("offset").asLong(0L);
        this.blockLen = obj.path("blockLen").asInt(0);
        this.lastCtx = obj.path("ctx").asText() == null ? "" : obj.path("ctx").asText();
        return this;
    }

    public void addSuccessLength(long len) {
        this.successLength += len;
        this.start += len;
    }

    public JsonNode toJSON() {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("blockIdx", this.blockIdx);
        json.put("start", this.start);
        json.put("offset", this.offset);
        json.put("blockLen", this.blockLen);
        json.put("ctx", this.lastCtx);
        return json;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    public int getBlockIdx() {
        return this.blockIdx;
    }

    public void setBlockIdx(int blockIdx) {
        this.blockIdx = blockIdx;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getBlockLen() {
        return this.blockLen;
    }

    public void setBlockLen(int blockLen) {
        this.blockLen = blockLen;
    }

    public String getLastCtx() {
        return this.lastCtx;
    }

    public void setLastCtx(String lastCtx) {
        this.lastCtx = lastCtx;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public long getSuccessLength() {
        return this.successLength;
    }

    public void setSuccessLength(long successLength) {
        this.successLength = successLength;
    }
}

