/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.wsbox;

import com.chinanetcenter.api.entity.HttpClientResult;
import com.chinanetcenter.api.entity.PutPolicy;
import com.chinanetcenter.api.exception.WsClientException;
import com.chinanetcenter.api.http.HttpClientUtil;
import com.chinanetcenter.api.util.Config;
import com.chinanetcenter.api.util.DateUtil;
import com.chinanetcenter.api.util.TokenUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FileUploadManage {
    public HttpClientResult upload(String bucketName, String fileKey, String srcFile) throws WsClientException {
        PutPolicy putPolicy = new PutPolicy();
        putPolicy.setScope(bucketName + ":" + fileKey);
        putPolicy.setOverwrite(1);
        putPolicy.setDeadline(String.valueOf(DateUtil.nextHours(1, new Date()).getTime()));
        return this.upload(bucketName, fileKey, srcFile, putPolicy);
    }

    public HttpClientResult upload(String bucketName, String fileKey, InputStream in) throws WsClientException {
        PutPolicy putPolicy = new PutPolicy();
        putPolicy.setScope(bucketName + ":" + fileKey);
        putPolicy.setOverwrite(1);
        putPolicy.setDeadline(String.valueOf(DateUtil.nextHours(1, new Date()).getTime()));
        String fileName = fileKey;
        if (fileName.contains("/")) {
            fileName = StringUtils.substringAfterLast((String)fileName, (String)"/");
        }
        return this.upload(bucketName, fileKey, fileName, in, putPolicy);
    }

    public HttpClientResult upload(String bucketName, String fileKey, String srcFile, PutPolicy putPolicy) throws WsClientException {
        if (putPolicy.getDeadline() == null) {
            putPolicy.setDeadline(String.valueOf(DateUtil.nextHours(1, new Date()).getTime()));
        }
        if (StringUtils.isEmpty((CharSequence)fileKey)) {
            putPolicy.setScope(bucketName);
        } else {
            putPolicy.setScope(bucketName + ":" + fileKey);
        }
        String uploadToken = TokenUtil.getUploadToken(putPolicy);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("token", uploadToken);
        return this.upload(paramMap, srcFile);
    }

    public HttpClientResult upload(String bucketName, String fileKey, String fileName, InputStream inputStream, PutPolicy putPolicy) throws WsClientException {
        if (putPolicy.getDeadline() == null) {
            putPolicy.setDeadline(String.valueOf(DateUtil.nextHours(1, new Date()).getTime()));
        }
        if (fileKey == null || fileKey.equals("")) {
            putPolicy.setScope(bucketName);
        } else {
            putPolicy.setScope(bucketName + ":" + fileKey);
        }
        String uploadToken = TokenUtil.getUploadToken(putPolicy);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("token", uploadToken);
        return this.upload(paramMap, fileName, inputStream);
    }

    public HttpClientResult upload(Map<String, String> paramMap, String fileName, InputStream inputStream) throws WsClientException {
        String url = Config.PUT_URL + "/file/upload";
        return HttpClientUtil.httpPost(url, null, paramMap, fileName, inputStream);
    }

    public HttpClientResult upload(Map<String, String> paramMap, String srcFile) throws WsClientException {
        String url = Config.PUT_URL + "/file/upload";
        File file = new File(srcFile);
        return HttpClientUtil.httpPost(url, paramMap, null, file);
    }

    public HttpClientResult multiUpload(List<File> fileList, PutPolicy putPolicy, Map<String, String> xParams) throws WsClientException {
        String url = Config.PUT_URL + "/multifile/upload";
        if (putPolicy.getDeadline() == null) {
            putPolicy.setDeadline(String.valueOf(DateUtil.nextHours(1, new Date()).getTime()));
        }
        String uploadToken = TokenUtil.getUploadToken(putPolicy);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("token", uploadToken);
        if (xParams != null && xParams.size() > 0) {
            for (Map.Entry<String, String> entry : xParams.entrySet()) {
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        return HttpClientUtil.httpMultiPost(url, null, paramMap, fileList);
    }
}

