/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.http;

import com.chinanetcenter.api.entity.HttpClientResult;
import com.chinanetcenter.api.entity.JsonValidator;
import com.chinanetcenter.api.exception.WsClientException;
import com.chinanetcenter.api.util.EncodeUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharsetUtils;

public class HttpClientUtil {
    public static HttpClientResult httpPost(String url, Map<String, String> params) throws WsClientException {
        return HttpClientUtil.httpPost(url, params, null, null);
    }

    public static HttpClientResult httpPost(String url, Map<String, String> params, Map<String, String> headMap) throws WsClientException {
        return HttpClientUtil.httpPost(url, params, headMap, null);
    }

    public static CloseableHttpClient getHttpClient() {
        CloseableHttpClient httpClient = null;
        try {
            HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

                public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                    System.out.println("request fail retryRequest false");
                    return false;
                }
            };
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30000).setSocketTimeout(30000).setConnectTimeout(30000).setRedirectsEnabled(false).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(50);
            cm.setDefaultMaxPerRoute(30);
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(30000).build();
            cm.setDefaultSocketConfig(socketConfig);
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).setRetryHandler(myRetryHandler).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return httpClient;
    }

    public static CloseableHttpClient createHttpClient(String url) {
        CloseableHttpClient httpClient = null;
        try {
            HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

                public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                    System.out.println("request fail retryRequest false");
                    return false;
                }
            };
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30000).setSocketTimeout(30000).setConnectTimeout(30000).setRedirectsEnabled(false).build();
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(30000).build();
            if (StringUtils.startsWith((CharSequence)url, (CharSequence)"https://")) {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
                SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                return HttpClients.custom().setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).setRetryHandler(myRetryHandler).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).build();
            }
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(50);
            cm.setDefaultMaxPerRoute(30);
            cm.setDefaultSocketConfig(socketConfig);
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).setRetryHandler(myRetryHandler).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return httpClient;
    }

    public static HttpClientResult httpPost(String url, Map<String, String> params, Map<String, String> headMap, File file) throws WsClientException {
        HttpClientResult httpClientResult;
        String response = "";
        HttpPost httpPost = null;
        CloseableHttpResponse ht = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            String readLine;
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> paramsList = new ArrayList<BasicNameValuePair>();
            if (file != null) {
                MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                mEntityBuilder.setCharset(Charset.forName("UTF-8"));
                FileBody fileBody = new FileBody(file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
                mEntityBuilder.addPart("file", (ContentBody)fileBody);
                mEntityBuilder.addTextBody("desc", file.getName());
                if (params != null && params.size() > 0) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        mEntityBuilder.addTextBody(entry.getKey(), entry.getValue(), ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8")));
                    }
                }
                httpPost.setEntity(mEntityBuilder.build());
            } else if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    paramsList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity he = null;
                try {
                    he = new UrlEncodedFormEntity(paramsList, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                httpPost.setEntity((HttpEntity)he);
            }
            if (headMap != null && headMap.size() > 0) {
                for (Map.Entry<String, String> entry : headMap.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (!httpPost.containsHeader("User-Agent")) {
                httpPost.addHeader("User-Agent", "wcs-java-sdk-2.0.0");
            }
            CloseableHttpClient hc = HttpClientUtil.createHttpClient(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            ht = hc.execute((HttpUriRequest)httpPost);
            HttpEntity het = ht.getEntity();
            is = het.getContent();
            br = new BufferedReader(new InputStreamReader(is, "utf8"));
            StringBuffer sb = new StringBuffer();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            response = response + sb.toString();
            int status = ht.getStatusLine().getStatusCode();
            if (status == 200 && !new JsonValidator().validate(response)) {
                response = EncodeUtils.urlsafeDecodeString(response);
            }
            httpClientResult = new HttpClientResult(url, status, response);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                throw new WsClientException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(ht);
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Closeable)ht);
        if (httpPost != null) {
            httpPost.releaseConnection();
        }
        return httpClientResult;
    }

    public static HttpClientResult httpGet(String url, Map<String, String> headMap) throws WsClientException {
        HttpClientResult httpClientResult;
        CloseableHttpResponse ht;
        block9: {
            HttpGet httpGet = null;
            ht = null;
            try {
                String readLine;
                httpGet = new HttpGet(url);
                if (headMap != null && headMap.size() > 0) {
                    for (Map.Entry<String, String> entry : headMap.entrySet()) {
                        httpGet.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                if (!httpGet.containsHeader("User-Agent")) {
                    httpGet.addHeader("User-Agent", "wcs-java-sdk-2.0.0");
                }
                CloseableHttpClient hc = HttpClientUtil.createHttpClient(url);
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
                httpGet.setConfig(requestConfig);
                ht = hc.execute((HttpUriRequest)httpGet);
                HttpEntity het = ht.getEntity();
                InputStream is = het.getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf8"));
                StringBuffer sb = new StringBuffer();
                while ((readLine = br.readLine()) != null) {
                    sb.append(readLine);
                }
                is.close();
                br.close();
                int status = ht.getStatusLine().getStatusCode();
                httpClientResult = new HttpClientResult(url, status, sb.toString());
                if (httpGet == null) break block9;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    throw new WsClientException(e);
                }
                catch (Throwable throwable) {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    IOUtils.closeQuietly(ht);
                    throw throwable;
                }
            }
            httpGet.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)ht);
        return httpClientResult;
    }

    public static HttpClientResult httpPost(String url, Map<String, String> headMap, Map<String, String> params, String fileName, InputStream inputStream) throws WsClientException {
        HttpClientResult httpClientResult;
        BufferedReader br;
        InputStream is;
        CloseableHttpClient hc;
        CloseableHttpResponse ht;
        block18: {
            String response = "";
            HttpPost httpPost = null;
            ht = null;
            hc = null;
            is = null;
            br = null;
            try {
                String readLine;
                httpPost = new HttpPost(url);
                ArrayList<BasicNameValuePair> paramsList = new ArrayList<BasicNameValuePair>();
                if (inputStream != null) {
                    MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                    mEntityBuilder.setCharset(Charset.forName("UTF-8"));
                    InputStreamBody fileBody = new InputStreamBody(inputStream, fileName);
                    mEntityBuilder.addPart("file", (ContentBody)fileBody);
                    mEntityBuilder.addTextBody("desc", fileName);
                    if (params != null && params.size() > 0) {
                        for (Map.Entry<String, String> entry : params.entrySet()) {
                            mEntityBuilder.addTextBody(entry.getKey(), entry.getValue(), ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8")));
                        }
                    }
                    httpPost.setEntity(mEntityBuilder.build());
                } else if (params != null && params.size() > 0) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        paramsList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                    }
                    UrlEncodedFormEntity he = null;
                    try {
                        he = new UrlEncodedFormEntity(paramsList, "utf-8");
                    }
                    catch (UnsupportedEncodingException entry) {
                        // empty catch block
                    }
                    httpPost.setEntity(he);
                }
                if (headMap != null && headMap.size() > 0) {
                    for (Map.Entry<String, String> entry : headMap.entrySet()) {
                        httpPost.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                if (!httpPost.containsHeader("User-Agent")) {
                    httpPost.addHeader("User-Agent", "wcs-java-sdk-2.0.0");
                }
                hc = HttpClientUtil.createHttpClient(url);
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
                httpPost.setConfig(requestConfig);
                ht = hc.execute((HttpUriRequest)httpPost);
                HttpEntity het = ht.getEntity();
                is = het.getContent();
                br = new BufferedReader(new InputStreamReader(is, "utf8"));
                StringBuffer sb = new StringBuffer();
                while ((readLine = br.readLine()) != null) {
                    sb.append(readLine);
                }
                response = response + sb.toString();
                int status = ht.getStatusLine().getStatusCode();
                if (status == 200 && !new JsonValidator().validate(response)) {
                    response = EncodeUtils.urlsafeDecodeString(response);
                }
                httpClientResult = new HttpClientResult(url, status, response);
                if (httpPost == null) break block18;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    throw new WsClientException(e);
                }
                catch (Throwable throwable) {
                    if (httpPost != null) {
                        httpPost.releaseConnection();
                    }
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(ht);
                    IOUtils.closeQuietly(hc);
                    throw throwable;
                }
            }
            httpPost.releaseConnection();
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Closeable)ht);
        IOUtils.closeQuietly((Closeable)hc);
        return httpClientResult;
    }

    public static HttpClientResult httpMultiPost(String url, Map<String, String> headMap, Map<String, String> params, List<File> fileList) throws WsClientException {
        HttpClientResult httpClientResult;
        HttpPost httpPost = null;
        CloseableHttpResponse ht = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            String readLine;
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> paramsList = new ArrayList<BasicNameValuePair>();
            MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            mEntityBuilder.setCharset(Charset.forName("utf-8"));
            if (fileList != null && fileList.size() > 0) {
                for (int i = 0; i < fileList.size(); ++i) {
                    File file = fileList.get(i);
                    FileBody fileBody = new FileBody(file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
                    mEntityBuilder.addPart("file", (ContentBody)fileBody);
                }
                if (params != null && params.size() > 0) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        mEntityBuilder.addTextBody(entry.getKey(), entry.getValue(), ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8")));
                    }
                }
                httpPost.setEntity(mEntityBuilder.setCharset(CharsetUtils.get((String)"UTF-8")).build());
            } else if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    paramsList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity he = new UrlEncodedFormEntity(paramsList, "utf-8");
                httpPost.setEntity((HttpEntity)he);
            }
            if (headMap != null && headMap.size() > 0) {
                for (Map.Entry<String, String> entry : headMap.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (!httpPost.containsHeader("User-Agent")) {
                httpPost.addHeader("User-Agent", "wcs-java-sdk-2.0.0");
            }
            CloseableHttpClient hc = HttpClientUtil.createHttpClient(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).build();
            httpPost.setConfig(requestConfig);
            ht = hc.execute((HttpUriRequest)httpPost);
            HttpEntity het = ht.getEntity();
            is = het.getContent();
            br = new BufferedReader(new InputStreamReader(is, "utf8"));
            StringBuffer sb = new StringBuffer();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            int status = ht.getStatusLine().getStatusCode();
            httpClientResult = new HttpClientResult(url, status, sb.toString());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                throw new WsClientException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(ht);
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Closeable)ht);
        if (httpPost != null) {
            httpPost.releaseConnection();
        }
        return httpClientResult;
    }

    public static HttpClientResult httpPostStringEntity(String url, Map<String, String> headMap, String body) throws WsClientException {
        HttpClientResult httpClientResult;
        HttpPost httpPost = null;
        CloseableHttpResponse ht = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            String readLine;
            httpPost = new HttpPost(url);
            StringEntity s = new StringEntity(body, "utf-8");
            httpPost.setEntity((HttpEntity)s);
            if (headMap != null && headMap.size() > 0) {
                for (Map.Entry<String, String> entry : headMap.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (!httpPost.containsHeader("User-Agent")) {
                httpPost.addHeader("User-Agent", "wcs-java-sdk-2.0.0");
            }
            CloseableHttpClient hc = HttpClientUtil.createHttpClient(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            ht = hc.execute((HttpUriRequest)httpPost);
            HttpEntity het = ht.getEntity();
            is = het.getContent();
            br = new BufferedReader(new InputStreamReader(is, "utf8"));
            StringBuffer sb = new StringBuffer();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            int status = ht.getStatusLine().getStatusCode();
            httpClientResult = new HttpClientResult(url, status, sb.toString());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                throw new WsClientException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(ht);
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Closeable)ht);
        if (httpPost != null) {
            httpPost.releaseConnection();
        }
        return httpClientResult;
    }
}

