/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.sliceUpload;

import com.chinanetcenter.api.entity.SliceUploadHttpResult;
import com.chinanetcenter.api.http.HttpClientUtil;
import com.chinanetcenter.api.sliceUpload.BlockObject;
import com.chinanetcenter.api.sliceUpload.JSONObjectRet;
import com.chinanetcenter.api.sliceUpload.PutExtra;
import com.chinanetcenter.api.util.Config;
import com.chinanetcenter.api.util.EncodeUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class BaseBlockUtil {
    public static int KB = 1024;
    public static int MB = 1024 * KB;
    public static int BLOCK_SIZE = 4 * MB;
    public static int CHUNK_SIZE = 256 * KB;
    public static int TRIED_TIMES = 3;
    public static int THREAD_NUN = 5;
    public static boolean isPersist = true;
    public static String properties_file_path = "";
    private static Logger logger = Logger.getLogger(BaseBlockUtil.class);
    public BlockObject blockObject;
    public JSONObjectRet jsonObjectRet;
    public PutExtra putExtra;
    protected Map<String, String> headMap;
    protected int REQUEST_TIMEOUT = 60000;
    protected int SO_TIMEOUT = 300000;

    public BaseBlockUtil(BlockObject blockObject, JSONObjectRet jsonObjectRet, PutExtra putExtra, Map<String, String> headMap) {
        this.blockObject = blockObject;
        this.jsonObjectRet = jsonObjectRet;
        this.putExtra = putExtra;
        this.headMap = headMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePutExtra(String bucketName, String fileName, JsonNode obj) {
        File configFile;
        if (!isPersist) {
            return;
        }
        File file = configFile = BaseBlockUtil.getPropertiesFile(bucketName, fileName);
        synchronized (file) {
            FileOutputStream fileOutputStream = null;
            try {
                if (!configFile.getParentFile().exists()) {
                    configFile.getParentFile().mkdirs();
                }
                if (!configFile.exists()) {
                    configFile.createNewFile();
                }
                fileOutputStream = new FileOutputStream(configFile);
                ObjectMapper objectMapper = new ObjectMapper();
                fileOutputStream.write(objectMapper.writeValueAsString((Object)obj).getBytes());
                fileOutputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static PutExtra getPutExtra(String bucketName, String fileName) {
        if (!isPersist) {
            return null;
        }
        File configFile = BaseBlockUtil.getPropertiesFile(bucketName, fileName);
        if (!configFile.exists()) {
            return null;
        }
        int fileLen = (int)configFile.length();
        char[] chars = new char[fileLen];
        try {
            FileReader reader = new FileReader(configFile);
            reader.read(chars);
            String txt = String.valueOf(chars);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode obj = objectMapper.readTree(txt);
            return new PutExtra(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearPutExtra(String bucketName, String fileName) {
        if (!isPersist) {
            return;
        }
        File configFile = BaseBlockUtil.getPropertiesFile(bucketName, fileName);
        if (!configFile.exists()) {
            return;
        }
        configFile.delete();
    }

    public static File getPropertiesFile(String bucketName, String fileName) {
        String key = EncodeUtils.urlsafeEncode(fileName);
        String filePath = properties_file_path;
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            filePath = System.getProperty("java.io.tmpdir");
        }
        if (!filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        return new File(filePath + bucketName + File.separator + key + "_sliceConfig.properties");
    }

    protected String getBPutUrl() {
        return Config.PUT_URL + "/bput/" + this.blockObject.getLastCtx() + "/" + this.blockObject.getStart();
    }

    protected String getMkBlkUrl() {
        return Config.PUT_URL + "/mkblk/" + this.blockObject.getBlockLen() + "/" + this.blockObject.getBlockIdx();
    }

    public SliceUploadHttpResult mkFile(Map<String, String> headMap, String key, PutExtra putExtra, int time) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse ht = null;
        HttpPost httpPost = null;
        try {
            String readLine;
            StringBuffer ctx = new StringBuffer();
            for (BlockObject blockObject : putExtra.processes) {
                ctx.append(",").append(blockObject.getLastCtx());
            }
            String url = this.buildMkFileUrl(putExtra.totalSize, key, putExtra.xParams);
            httpClient = HttpClientUtil.createHttpClient(url);
            httpPost = new HttpPost(url);
            if (!httpPost.containsHeader("User-Agent")) {
                httpPost.addHeader("User-Agent", "wcs-java-sdk-2.0.0");
            }
            if (headMap != null && headMap.size() > 0) {
                for (Map.Entry entry : headMap.entrySet()) {
                    httpPost.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            httpPost.setEntity((HttpEntity)new StringEntity(ctx.substring(1)));
            ht = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity het = ht.getEntity();
            InputStream inputStream = het.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "utf8"));
            StringBuffer sb = new StringBuffer();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            inputStream.close();
            br.close();
            SliceUploadHttpResult ret = new SliceUploadHttpResult(ht.getStatusLine().getStatusCode(), sb.toString());
            if ((ret.status == 401 || ret.status == 412 || ret.status / 100 == 5 && ret.status != 579) && time < TRIED_TIMES) {
                SliceUploadHttpResult sliceUploadHttpResult = this.mkFile(headMap, key, putExtra, time + 1);
                return sliceUploadHttpResult;
            }
            SliceUploadHttpResult sliceUploadHttpResult = ret;
            return sliceUploadHttpResult;
        }
        catch (Exception e) {
            if (e instanceof ClientProtocolException) {
                String message = "make file ClientProtocolException, key:" + key + " ,ClientProtocolException error,Message:" + e.getMessage();
                logger.error((Object)("make file ClientProtocolException error," + message));
            }
            if (time < TRIED_TIMES) {
                SliceUploadHttpResult sliceUploadHttpResult = this.mkFile(headMap, key, putExtra, time + 1);
                return sliceUploadHttpResult;
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                if (ht != null) {
                    ht.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String buildMkFileUrl(long length, String key, Map<String, String> params) {
        StringBuffer url = new StringBuffer();
        url.append(Config.PUT_URL).append("/mkfile/").append(length);
        if (null != key) {
            url.append("/key/").append(new String(EncodeUtils.urlsafeEncodeBytes(key.getBytes())));
        }
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, String> a : params.entrySet()) {
                url.append("/").append(a.getKey()).append("/").append(new String(EncodeUtils.urlsafeEncodeBytes(a.getValue().getBytes())));
            }
        }
        return url.toString();
    }

    public SliceUploadHttpResult handleResult(CloseableHttpResponse response) {
        try {
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            return new SliceUploadHttpResult(statusCode, responseBody);
        }
        catch (Exception e) {
            return new SliceUploadHttpResult(500, "can not load response.");
        }
    }

    public HttpPost buildUpPost(String url) {
        HttpPost post = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.SO_TIMEOUT).setConnectTimeout(this.REQUEST_TIMEOUT).build();
        post.setConfig(requestConfig);
        return post;
    }

    public HttpEntity buildHttpEntity(final RandomAccessFile file, final long offset, final int len) {
        AbstractHttpEntity entity = new AbstractHttpEntity(){
            private boolean consumed = false;
            private long length = len;

            public boolean isRepeatable() {
                return true;
            }

            public long getContentLength() {
                return this.length;
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(OutputStream os) throws IOException {
                this.consumed = false;
                try {
                    byte[] b = new byte[4096];
                    int totalLength = 0;
                    file.seek(offset);
                    while (true) {
                        long len2;
                        if (this.length - (long)totalLength < (long)b.length) {
                            int lastLength = (int)(this.length - (long)totalLength);
                            b = new byte[lastLength];
                        }
                        if ((len2 = (long)file.read(b)) == -1L || (long)totalLength >= this.length) break;
                        os.write(b, 0, (int)len2);
                        totalLength = (int)((long)totalLength + len2);
                    }
                    os.flush();
                }
                finally {
                    os.close();
                    this.consumed = true;
                }
            }

            public boolean isStreaming() {
                return !this.consumed;
            }
        };
        entity.setContentType("application/octet-stream");
        return entity;
    }

    protected long buildCrc32(int len) {
        return this.crc32(this.getByteData(len));
    }

    protected String getFileMD5String(int len) {
        byte[] data = this.getByteData(len);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            return this.toHex(md.digest());
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private String toHex(byte[] buffer) {
        StringBuilder sb = new StringBuilder();
        for (byte aBuffer : buffer) {
            String s = Integer.toHexString(aBuffer & 0xFF);
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private byte[] getByteData(int len) {
        byte[] data = new byte[len];
        try {
            this.blockObject.file.seek(this.blockObject.getOffset() + this.blockObject.getStart());
            this.blockObject.file.read(data);
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long crc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }
}

