/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.sliceUpload;

import com.chinanetcenter.api.entity.SliceUploadHttpResult;
import com.chinanetcenter.api.exception.WsClientException;
import com.chinanetcenter.api.http.HttpClientUtil;
import com.chinanetcenter.api.sliceUpload.BaseBlockUtil;
import com.chinanetcenter.api.sliceUpload.BlockObject;
import com.chinanetcenter.api.sliceUpload.JSONObjectRet;
import com.chinanetcenter.api.sliceUpload.PutExtra;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.http.HttpException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;

public class BlockUpload
extends BaseBlockUtil
implements Callable {
    private static Logger logger = Logger.getLogger(BlockUpload.class);

    public BlockUpload(BlockObject blockObject, JSONObjectRet jsonObjectRet, PutExtra putExtra1, Map<String, String> headMap) {
        super(blockObject, jsonObjectRet, putExtra1, headMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockObject call() throws Exception {
        int retry = 0;
        boolean isOut = false;
        while (!isOut) {
            try {
                isOut = true;
                this.buildBlockUpload();
            }
            catch (WsClientException e) {
                if (e.code == 412 && retry < 3) {
                    isOut = false;
                    this.blockObject.setStart(0L);
                    this.blockObject.setSuccessLength(0L);
                    ++retry;
                    continue;
                }
                throw e;
            }
            finally {
                if (!isOut) continue;
                this.blockObject.file.close();
            }
        }
        return this.blockObject;
    }

    public void buildBlockUpload() throws Exception {
        if (this.blockObject.getStart() >= (long)this.blockObject.getBlockLen()) {
            return;
        }
        this.blockObject.setStart(0L);
        this.blockObject.setSuccessLength(0L);
        if (this.blockObject.getStart() == 0L) {
            int chunkLength = Math.min(this.blockObject.getBlockLen(), CHUNK_SIZE);
            this.buildMkBlk(chunkLength, 0);
        }
        if (this.blockObject.getBlockLen() > CHUNK_SIZE) {
            int count = (int)(((long)this.blockObject.getBlockLen() - this.blockObject.getStart() + (long)CHUNK_SIZE - 1L) / (long)CHUNK_SIZE);
            for (int i = 0; i < count; ++i) {
                int len = (int)Math.min((long)this.blockObject.getBlockLen() - this.blockObject.getStart(), (long)CHUNK_SIZE);
                this.buildBPut(len, 0);
            }
        }
    }

    private SliceUploadHttpResult buildMkBlk(int len, int time) throws Exception {
        String url = this.getMkBlkUrl();
        return this.upload(url, len, time);
    }

    private SliceUploadHttpResult buildBPut(int len, int time) throws Exception {
        String url = this.getBPutUrl();
        return this.upload(url, len, time);
    }

    private SliceUploadHttpResult upload(String url, int len, int time) throws Exception {
        HttpPost post = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientUtil.createHttpClient(url);
            post = this.buildUpPost(url);
            if (this.headMap != null && this.headMap.size() > 0) {
                for (Map.Entry entry : this.headMap.entrySet()) {
                    post.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!post.containsHeader("User-Agent")) {
                post.addHeader("User-Agent", "wcs-java-sdk-2.0.0");
            }
            long start = this.blockObject.getOffset() + this.blockObject.getStart();
            post.setEntity(this.buildHttpEntity(this.blockObject.file, start, len));
            response = httpClient.execute((HttpUriRequest)post);
            SliceUploadHttpResult ret = this.handleResult(response);
            SliceUploadHttpResult sliceUploadHttpResult = this.checkAndRetryUpload(url, len, time, ret);
            return sliceUploadHttpResult;
        }
        catch (WsClientException e) {
            String message = "url:" + url + ",blockIdx:" + this.blockObject.getBlockIdx() + " ,HttpClientException error,Message:" + e.getMessage();
            throw new WsClientException(e.code, message);
        }
        catch (ClientProtocolException cpe) {
            String message = "url:" + url + ",blockIdx:" + this.blockObject.getBlockIdx() + " ,ClientProtocolException error,Message:" + cpe.getMessage();
            logger.error((Object)message);
            throw new ClientProtocolException(message);
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
    }

    private SliceUploadHttpResult checkAndRetryUpload(String url, int len, int time, SliceUploadHttpResult result) throws Exception {
        if (!result.isOk()) {
            if ((result.getStatus() == 406 || result.getStatus() == 701 || result.getStatus() / 100 == 5) && time < TRIED_TIMES) {
                return this.upload(url, len, time + 1);
            }
            throw new WsClientException(result.getStatus(), url + "connect result error, stauts :" + result.getStatus() + " reason:" + (result.response == null ? "" : result.response));
        }
        long crc32 = this.buildCrc32(len);
        String checkSum = this.getFileMD5String(len);
        if (result.getCrc32() != crc32 || !result.getChecksum().equals(checkSum)) {
            if (time < TRIED_TIMES) {
                return this.upload(url, len, time + 1);
            }
            System.out.println("result.getCrc32():" + result.getCrc32() + ",crc32:" + crc32);
            throw new HttpException("406 inner block's crc32 do not match." + (result.response == null ? "" : result.response));
        }
        this.blockObject.addSuccessLength(len);
        this.blockObject.setLastCtx(result.getCtx());
        this.jsonObjectRet.onPersist(this.putExtra.toJSON());
        long current = 0L;
        for (BlockObject blockObject1 : this.putExtra.processes) {
            current += blockObject1.getStart();
        }
        this.jsonObjectRet.onProcess(current, this.putExtra.totalSize);
        return result;
    }
}

