/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.sliceUpload;

import com.chinanetcenter.api.entity.PutPolicy;
import com.chinanetcenter.api.sliceUpload.BlockObject;
import com.chinanetcenter.api.util.TokenUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class PutExtra {
    public Map<String, String> params;
    public Map<String, String> xParams;
    public BlockObject[] processes;
    public String mimeType;
    public long totalSize;
    public String uploadBatch;

    public PutExtra() {
    }

    public PutExtra(String bucketName, String fileKey, String filePath, PutPolicy putPolicy, long fileSize) {
        String uploadBatch;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bucketName", bucketName);
        params.put("fileKey", fileKey);
        params.put("filePath", filePath);
        params.put("putPolicy", putPolicy.toString());
        String token = TokenUtil.getUploadToken(putPolicy);
        params.put("token", token);
        this.uploadBatch = uploadBatch = "JAVA-SDK-" + UUID.randomUUID();
        this.totalSize = fileSize;
        this.params = params;
    }

    public PutExtra(JsonNode obj) {
        String key;
        this.mimeType = obj.path("mimeType").asText() == null ? "" : obj.path("mimeType").asText();
        this.uploadBatch = obj.path("uploadBatch").asText() == null ? "" : obj.path("uploadBatch").asText();
        this.totalSize = obj.path("totalSize") == null ? 0L : obj.path("totalSize").asLong();
        JsonNode procs = obj.path("processes");
        this.processes = new BlockObject[procs.size()];
        for (int i = 0; i < procs.size(); ++i) {
            this.processes[i] = new BlockObject(procs.get(i));
        }
        this.params = new HashMap<String, String>();
        this.xParams = new HashMap<String, String>();
        JsonNode paramsJson = obj.path("params");
        JsonNode xParamsJson = obj.path("xParams");
        Iterator iter = paramsJson.fieldNames();
        while (iter.hasNext()) {
            key = (String)iter.next();
            this.params.put(key, paramsJson.path(key).asText());
        }
        if (xParamsJson != null && xParamsJson.fieldNames() != null) {
            iter = xParamsJson.fieldNames();
            while (iter.hasNext()) {
                key = (String)iter.next();
                this.xParams.put(key, xParamsJson.path(key).asText());
            }
        }
    }

    public boolean isFinishAll() {
        if (this.totalSize <= 0L) {
            return false;
        }
        long currentSize = 0L;
        for (BlockObject pr : this.processes) {
            currentSize += pr.getOffset();
        }
        return currentSize >= this.totalSize;
    }

    public JsonNode toJSON() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        ArrayNode process = JsonNodeFactory.instance.arrayNode();
        for (BlockObject p : this.processes) {
            process.add(p.toJSON());
        }
        json.put("processes", (JsonNode)process);
        json.put("mimeType", this.mimeType);
        json.put("uploadBatch", this.uploadBatch);
        json.put("totalSize", this.totalSize);
        if (this.params != null) {
            json.put("params", objectMapper.readTree(objectMapper.writeValueAsString(this.params)));
        }
        if (this.xParams != null) {
            json.put("xParams", objectMapper.readTree(objectMapper.writeValueAsString(this.xParams)));
        }
        return json;
    }
}

