/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;

public class EncodeUtils {
    public static byte[] urlsafeEncodeBytes(byte[] src) {
        if (src.length % 3 == 0) {
            return EncodeUtils.encodeBase64Ex(src);
        }
        byte[] b = EncodeUtils.encodeBase64Ex(src);
        if (b.length % 4 == 0) {
            return b;
        }
        int pad = 4 - b.length % 4;
        byte[] b2 = new byte[b.length + pad];
        System.arraycopy(b, 0, b2, 0, b.length);
        b2[b.length] = 61;
        if (pad > 1) {
            b2[b.length + 1] = 61;
        }
        return b2;
    }

    public static byte[] urlsafeBase64Decode(String encoded) {
        byte[] rawbs = encoded.getBytes();
        for (int i = 0; i < rawbs.length; ++i) {
            if (rawbs[i] == 95) {
                rawbs[i] = 47;
                continue;
            }
            if (rawbs[i] != 45) continue;
            rawbs[i] = 43;
        }
        return Base64.decodeBase64((byte[])rawbs);
    }

    public static String urlsafeDecodeString(String encoded) {
        String str = null;
        try {
            str = new String(EncodeUtils.urlsafeBase64Decode(encoded), "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            str = new String(EncodeUtils.urlsafeBase64Decode(encoded));
        }
        return str;
    }

    public static String urlsafeEncodeString(byte[] src) {
        String str = null;
        try {
            str = new String(EncodeUtils.urlsafeEncodeBytes(src), "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            str = new String(EncodeUtils.urlsafeEncodeBytes(src));
        }
        return str;
    }

    public static String urlsafeEncode(String text) {
        String str = null;
        try {
            str = new String(EncodeUtils.urlsafeEncodeBytes(text.getBytes("utf-8")), "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            str = new String(EncodeUtils.urlsafeEncodeBytes(text.getBytes()));
        }
        return str;
    }

    private static byte[] encodeBase64Ex(byte[] src) {
        byte[] b64 = Base64.encodeBase64((byte[])src);
        for (int i = 0; i < b64.length; ++i) {
            if (b64[i] == 47) {
                b64[i] = 95;
                continue;
            }
            if (b64[i] != 43) continue;
            b64[i] = 45;
        }
        return b64;
    }

    public static String escapeFileKey(String fileKey) {
        try {
            fileKey = URLEncoder.encode(fileKey, "UTF-8");
            fileKey = fileKey.replace("%2F", "/");
            fileKey = fileKey.replace("+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return fileKey;
    }
}

