/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.util;

import com.chinanetcenter.api.entity.PutPolicy;
import com.chinanetcenter.api.util.Config;
import com.chinanetcenter.api.util.DateUtil;
import com.chinanetcenter.api.util.EncodeUtils;
import com.chinanetcenter.api.util.EncryptUtil;
import com.chinanetcenter.api.util.JsonMapper;

public class TokenUtil {
    public static void main(String[] args) {
        PutPolicy putPolicy = new PutPolicy();
        putPolicy.setScope("viptest:moteltest001.mp4");
        Long time = DateUtil.parseDate("2050-01-01 12:00:00", "yyyy-MM-dd HH:mm:ss").getTime();
        putPolicy.setDeadline(String.valueOf(time));
        String uploadToken = TokenUtil.getUploadToken(putPolicy);
        System.out.println(uploadToken);
    }

    public static String getUploadToken(PutPolicy putPolicy) {
        JsonMapper jsonMapper = JsonMapper.nonEmptyMapper();
        String putPolicyStr = jsonMapper.toJson(putPolicy);
        String encodePutPolicy = EncodeUtils.urlsafeEncode(putPolicyStr);
        String singSk = EncryptUtil.sha1Hex(encodePutPolicy.getBytes(), Config.SK);
        String skValue = EncodeUtils.urlsafeEncode(singSk);
        String uploadToken = Config.AK + ":" + skValue + ":" + encodePutPolicy;
        return uploadToken;
    }

    public static String getDeleteToken(String bucketName, String fileName) {
        String encodedEntryURI = EncodeUtils.urlsafeEncodeString((bucketName + ":" + fileName).getBytes());
        String encodeDeletePath = "/delete/" + encodedEntryURI + "\n";
        String signSk = EncryptUtil.sha1Hex(encodeDeletePath.getBytes(), Config.SK);
        String encodedSign = EncodeUtils.urlsafeEncode(signSk);
        String deleteToken = Config.AK + ":" + encodedSign;
        return deleteToken;
    }

    public static String getDeletePrefixToken(String bucketName, String fileName) {
        String encodedEntryURI = EncodeUtils.urlsafeEncodeString((bucketName + ":" + fileName).getBytes());
        String encodeDeletePath = "/deletePrefix/" + encodedEntryURI + "\n";
        String signSk = EncryptUtil.sha1Hex(encodeDeletePath.getBytes(), Config.SK);
        String encodedSign = EncodeUtils.urlsafeEncode(signSk);
        String deleteToken = Config.AK + ":" + encodedSign;
        return deleteToken;
    }

    public static String getStatToken(String bucketName, String fileName) {
        String encodedEntryURI = EncodeUtils.urlsafeEncodeString((bucketName + ":" + fileName).getBytes());
        String encodeDeletePath = "/stat/" + encodedEntryURI + "\n";
        String signSk = EncryptUtil.sha1Hex(encodeDeletePath.getBytes(), Config.SK);
        String encodedSign = EncodeUtils.urlsafeEncode(signSk);
        String deleteToken = Config.AK + ":" + encodedSign;
        return deleteToken;
    }

    public static String getFileListToken(String listUrl) {
        listUrl = listUrl + "\n";
        String encodeDownloadUrl = EncryptUtil.sha1Hex(listUrl.getBytes(), Config.SK);
        String skValues = EncodeUtils.urlsafeEncode(encodeDownloadUrl);
        String listToken = Config.AK + ":" + skValues;
        return listToken;
    }
}

