/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.api.wsbox;

import com.chinanetcenter.api.entity.PutPolicy;
import com.chinanetcenter.api.entity.SliceUploadHttpResult;
import com.chinanetcenter.api.exception.WsClientException;
import com.chinanetcenter.api.sliceUpload.BaseBlockUtil;
import com.chinanetcenter.api.sliceUpload.BlockObject;
import com.chinanetcenter.api.sliceUpload.BlockUpload;
import com.chinanetcenter.api.sliceUpload.JSONObjectRet;
import com.chinanetcenter.api.sliceUpload.PutExtra;
import com.chinanetcenter.api.util.DateUtil;
import com.chinanetcenter.api.util.TokenUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SliceUploadResumable {
    public void execUpload(String bucketName, String fileKey, String filePath, PutPolicy putPolicy, PutExtra putExtra, JSONObjectRet jsonObjectRet) {
        this.execUpload(bucketName, fileKey, filePath, putPolicy, putExtra, jsonObjectRet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execUpload(String bucketName, String fileKey, String filePath, PutPolicy putPolicy, PutExtra putExtra, JSONObjectRet jsonObjectRet, Map<String, String> headMap) {
        RandomAccessFile file = null;
        ExecutorService pool = null;
        try {
            void var15_26;
            if (BaseBlockUtil.BLOCK_SIZE < 4 * BaseBlockUtil.MB || BaseBlockUtil.BLOCK_SIZE % (4 * BaseBlockUtil.MB) != 0) {
                jsonObjectRet.onFailure(new Exception("\u5757\u5927\u5c0f\u5e94\u8be5\u4e3a4M\u7684\u6574\u6570\u500d!"));
                return;
            }
            file = new RandomAccessFile(filePath, "r");
            pool = Executors.newFixedThreadPool(BaseBlockUtil.THREAD_NUN);
            ExecutorCompletionService completionService = new ExecutorCompletionService(pool);
            if ((putExtra == null || putExtra.processes == null || putExtra.totalSize != file.length()) && (putExtra = BaseBlockUtil.getPutExtra(bucketName, fileKey)) == null) {
                putExtra = new PutExtra();
                this.initPutExtra(bucketName, fileKey, file, putExtra, jsonObjectRet);
            }
            putPolicy.setDeadline(String.valueOf(DateUtil.nextHours(1, new Date()).getTime()));
            Date dealEndDate = DateUtil.nextMinute(5, new Date());
            String token = TokenUtil.getUploadToken(putPolicy);
            HashMap<String, String> currHeadMap = new HashMap<String, String>();
            currHeadMap.put("Authorization", "UpToken " + token);
            currHeadMap.put("uploadBatch", putExtra.uploadBatch);
            if (headMap != null && headMap.size() > 0) {
                for (Map.Entry<String, String> entry : headMap.entrySet()) {
                    currHeadMap.put(entry.getKey(), entry.getValue());
                }
            }
            int runnerThread = 0;
            for (BlockObject blockObject : putExtra.processes) {
                ++runnerThread;
                while (runnerThread > BaseBlockUtil.THREAD_NUN + 1) {
                    completionService.take().get();
                    --runnerThread;
                }
                if (dealEndDate.before(new Date())) {
                    dealEndDate = DateUtil.nextMinute(5, new Date());
                    putPolicy.setDeadline(String.valueOf(DateUtil.nextHours(1, new Date()).getTime()));
                    token = TokenUtil.getUploadToken(putPolicy);
                    currHeadMap.put("Authorization", "UpToken " + token);
                }
                RandomAccessFile blockFile = new RandomAccessFile(filePath, "r");
                blockObject.setCommonParam(blockFile, bucketName, fileKey);
                BlockUpload task = new BlockUpload(blockObject, jsonObjectRet, putExtra, currHeadMap);
                completionService.submit(task);
            }
            boolean bl = false;
            while (var15_26 < runnerThread) {
                completionService.take().get();
                ++var15_26;
            }
            pool.shutdown();
            putPolicy.setDeadline(String.valueOf(DateUtil.nextHours(1, new Date()).getTime()));
            token = TokenUtil.getUploadToken(putPolicy);
            currHeadMap.put("Authorization", "UpToken " + token);
            BaseBlockUtil baseBlockUtil = new BaseBlockUtil(null, jsonObjectRet, putExtra, currHeadMap);
            SliceUploadHttpResult result = baseBlockUtil.mkFile(currHeadMap, fileKey, putExtra, 0);
            if (result.getStatus() == 200) {
                jsonObjectRet.onSuccess(result.toJSON());
            } else {
                if (result.getStatus() == 412) {
                    System.out.println(fileKey + " \u6b64\u6587\u4ef6\u5757\u6709\u7f3a\u5931\uff0c\u6587\u4ef6\u91cd\u65b0\u4e0a\u4f20");
                    putPolicy.setOverwrite(1);
                }
                putExtra.processes = null;
                jsonObjectRet.onFailure(new WsClientException(result.getStatus(), result.getResponse()));
            }
            BaseBlockUtil.clearPutExtra(bucketName, fileKey);
        }
        catch (Exception e) {
            jsonObjectRet.onFailure(e);
        }
        finally {
            if (pool != null) {
                pool.shutdownNow();
            }
            if (file != null) {
                try {
                    for (int reTime = 0; pool != null && !pool.isTerminated() && reTime < 50; ++reTime) {
                        Thread.sleep(1000L);
                    }
                    file.close();
                }
                catch (Exception e) {
                    System.out.println("file close error");
                }
            }
        }
    }

    public void initPutExtra(String bucketName, String fileKey, RandomAccessFile file, PutExtra putExtra, JSONObjectRet ret) {
        try {
            if (putExtra == null) {
                putExtra = new PutExtra();
            }
            int blockCount = (int)((file.length() - 1L) / (long)BaseBlockUtil.BLOCK_SIZE) + 1;
            putExtra.processes = new BlockObject[blockCount];
            putExtra.totalSize = file.length();
            for (int i = 0; i < blockCount; ++i) {
                BlockObject blockObject;
                int blockLength = (int)Math.min(file.length() - (long)BaseBlockUtil.BLOCK_SIZE * (long)i, (long)BaseBlockUtil.BLOCK_SIZE);
                putExtra.processes[i] = blockObject = new BlockObject(file, bucketName, fileKey, i, blockLength);
            }
            putExtra.uploadBatch = "JAVA-SDK-" + UUID.randomUUID();
        }
        catch (IOException e) {
            ret.onFailure(e);
        }
    }
}

