/*
 * Decompiled with CFR 0.152.
 */
package com.cxytiandi.encrypt.core;

import com.cxytiandi.encrypt.springboot.init.ApiEncryptDataInit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="spring.encrypt")
public class EncryptionConfig {
    private String key = "d7b85f6e214abcda";
    private List<String> responseEncryptUriList = new ArrayList<String>();
    private List<String> requestDecryptUriList = new ArrayList<String>();
    private List<String> responseEncryptUriIgnoreList = new ArrayList<String>();
    private List<String> requestDecryptUriIgnoreList = new ArrayList<String>();
    private String responseCharset = "UTF-8";
    private boolean debug = false;
    private String[] urlPatterns = new String[]{"/*"};
    private int order = 1;

    public EncryptionConfig() {
    }

    public EncryptionConfig(String key, List<String> responseEncryptUriList, List<String> requestDecryptUriList, String responseCharset, boolean debug) {
        this.key = key;
        this.responseEncryptUriList = responseEncryptUriList;
        this.requestDecryptUriList = requestDecryptUriList;
        this.responseCharset = responseCharset;
        this.debug = debug;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<String> getResponseEncryptUriList() {
        return Stream.of(this.responseEncryptUriList, ApiEncryptDataInit.responseEncryptUriList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void setResponseEncryptUriList(List<String> responseEncryptUriList) {
        this.responseEncryptUriList = responseEncryptUriList;
    }

    public List<String> getRequestDecryptUriList() {
        return Stream.of(this.requestDecryptUriList, ApiEncryptDataInit.requestDecryptUriList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void setRequestDecryptUriList(List<String> requestDecryptUriList) {
        this.requestDecryptUriList = requestDecryptUriList;
    }

    public String getResponseCharset() {
        return this.responseCharset;
    }

    public void setResponseCharset(String responseCharset) {
        this.responseCharset = responseCharset;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setUrlPatterns(String[] urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public List<String> getResponseEncryptUriIgnoreList() {
        return Stream.of(this.responseEncryptUriIgnoreList, ApiEncryptDataInit.responseEncryptUriIgnoreList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void setResponseEncryptUriIgnoreList(List<String> responseEncryptUriIgnoreList) {
        this.responseEncryptUriIgnoreList = responseEncryptUriIgnoreList;
    }

    public List<String> getRequestDecryptUriIgnoreList() {
        return Stream.of(this.requestDecryptUriIgnoreList, ApiEncryptDataInit.requestDecryptUriIgnoreList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void setRequestDecryptUriIgnoreList(List<String> requestDecyptUriIgnoreList) {
        this.requestDecryptUriIgnoreList = requestDecyptUriIgnoreList;
    }

    public List<String> getRequestDecryptParams(String uri) {
        List<String> params = ApiEncryptDataInit.requestDecryptParamMap.get(uri);
        if (CollectionUtils.isEmpty(params)) {
            return new ArrayList<String>();
        }
        return params;
    }
}

