/*
 * Decompiled with CFR 0.152.
 */
package com.cxytiandi.encrypt.springboot.init;

import com.cxytiandi.encrypt.springboot.annotation.Decrypt;
import com.cxytiandi.encrypt.springboot.annotation.DecryptIgnore;
import com.cxytiandi.encrypt.springboot.annotation.Encrypt;
import com.cxytiandi.encrypt.springboot.annotation.EncryptIgnore;
import com.cxytiandi.encrypt.util.RequestUriUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;

public class ApiEncryptDataInit
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(ApiEncryptDataInit.class);
    public static List<String> responseEncryptUriList = new ArrayList<String>();
    public static List<String> requestDecryptUriList = new ArrayList<String>();
    public static List<String> responseEncryptUriIgnoreList = new ArrayList<String>();
    public static List<String> requestDecryptUriIgnoreList = new ArrayList<String>();
    public static Map<String, List<String>> requestDecryptParamMap = new HashMap<String, List<String>>();
    private String contextPath;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.contextPath = ctx.getEnvironment().getProperty("server.servlet.context-path");
        Map beanMap = ctx.getBeansWithAnnotation(Controller.class);
        this.initData(beanMap);
        this.initRequestDecyptParam(ctx.getEnvironment());
    }

    private void initRequestDecyptParam(Environment environment) {
        for (PropertySource propertySource : ((AbstractEnvironment)environment).getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (!name.startsWith("spring.encrypt.requestDecyptParam")) continue;
                String[] keys = name.split("\\.");
                String key = keys[keys.length - 1];
                String property = environment.getProperty(name);
                requestDecryptParamMap.put(key.replace("$", ":"), Arrays.asList(property.split(",")));
            }
        }
    }

    private void initData(Map<String, Object> beanMap) {
        if (beanMap != null) {
            for (Object bean : beanMap.values()) {
                Method[] methods;
                Class<?> clz = bean.getClass();
                for (Method method : methods = clz.getMethods()) {
                    DecryptIgnore decryptIgnore;
                    EncryptIgnore encryptIgnore;
                    Decrypt decrypt;
                    Encrypt encrypt = (Encrypt)AnnotationUtils.findAnnotation((Method)method, Encrypt.class);
                    if (encrypt != null) {
                        String uri = encrypt.value();
                        if (!StringUtils.hasText((String)uri)) {
                            uri = RequestUriUtils.getApiUri(clz, method, this.contextPath);
                        }
                        this.logger.debug("Encrypt URI: {}", (Object)uri);
                        responseEncryptUriList.add(uri);
                    }
                    if ((decrypt = (Decrypt)AnnotationUtils.findAnnotation((Method)method, Decrypt.class)) != null) {
                        String decyptParam;
                        String uri = decrypt.value();
                        if (!StringUtils.hasText((String)uri)) {
                            uri = RequestUriUtils.getApiUri(clz, method, this.contextPath);
                        }
                        if (StringUtils.hasText((String)(decyptParam = decrypt.decyptParam()))) {
                            requestDecryptParamMap.put(uri, Arrays.asList(decyptParam.split(",")));
                        }
                        this.logger.debug("Decrypt URI: {}", (Object)uri);
                        requestDecryptUriList.add(uri);
                    }
                    if ((encryptIgnore = (EncryptIgnore)AnnotationUtils.findAnnotation((Method)method, EncryptIgnore.class)) != null) {
                        String uri = encryptIgnore.value();
                        if (!StringUtils.hasText((String)uri)) {
                            uri = RequestUriUtils.getApiUri(clz, method, this.contextPath);
                        }
                        this.logger.debug("EncryptIgnore URI: {}", (Object)uri);
                        responseEncryptUriIgnoreList.add(uri);
                    }
                    if ((decryptIgnore = (DecryptIgnore)AnnotationUtils.findAnnotation((Method)method, DecryptIgnore.class)) == null) continue;
                    String uri = decryptIgnore.value();
                    if (!StringUtils.hasText((String)uri)) {
                        uri = RequestUriUtils.getApiUri(clz, method, this.contextPath);
                    }
                    this.logger.debug("DecryptIgnore URI: {}", (Object)uri);
                    requestDecryptUriIgnoreList.add(uri);
                }
            }
        }
    }
}

