/*
 * Decompiled with CFR 0.152.
 */
package com.cxytiandi.encrypt.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class AesEncryptUtils {
    public static final String KEY_ALGORITHM = "AES";
    public static final int DEFAULT_KEY_SIZE = 128;
    private static final String ECB_PKCS_5_PADDING = "AES/ECB/PKCS5Padding";
    public static final String ECB_NO_PADDING = "AES/ECB/NoPadding";

    private AesEncryptUtils() {
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] base64Decode(String base64Code) {
        return Base64.decodeBase64((String)base64Code);
    }

    public static byte[] aesEncryptToBytes(String content, String hexAesKey) throws Exception {
        return AesEncryptUtils.encrypt(content.getBytes(StandardCharsets.UTF_8), Hex.decodeHex((char[])hexAesKey.toCharArray()));
    }

    public static String aesEncrypt(String content, String hexAesKey) throws Exception {
        return AesEncryptUtils.base64Encode(AesEncryptUtils.aesEncryptToBytes(content, hexAesKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String hexAesKey) throws Exception {
        byte[] decrypt = AesEncryptUtils.decrypt(encryptBytes, Hex.decodeHex((char[])hexAesKey.toCharArray()));
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    public static String aesDecrypt(String encryptStr, String hexAesKey) throws Exception {
        return AesEncryptUtils.aesDecryptByBytes(AesEncryptUtils.base64Decode(encryptStr), hexAesKey);
    }

    public static String initHexKey() {
        return Hex.encodeHexString((byte[])AesEncryptUtils.initKey());
    }

    public static byte[] initKey() {
        return AesEncryptUtils.initKey(128);
    }

    public static byte[] initKey(int keySize) {
        KeyGenerator keyGenerator;
        if (keySize != 128 && keySize != 192 && keySize != 256) {
            throw new RuntimeException("error keySize: " + keySize);
        }
        try {
            keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("no such algorithm exception: AES", e);
        }
        keyGenerator.init(keySize);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    private static Key toKey(byte[] key) {
        return new SecretKeySpec(key, KEY_ALGORITHM);
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        return AesEncryptUtils.encrypt(data, key, ECB_PKCS_5_PADDING);
    }

    public static byte[] encrypt(byte[] data, byte[] key, String cipherAlgorithm) {
        Key k = AesEncryptUtils.toKey(key);
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(1, k);
            if (ECB_NO_PADDING.equals(cipherAlgorithm)) {
                return cipher.doFinal(AesEncryptUtils.formatWithZeroPadding(data, cipher.getBlockSize()));
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("AES encrypt error", e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        return AesEncryptUtils.decrypt(data, key, ECB_PKCS_5_PADDING);
    }

    public static byte[] decrypt(byte[] data, byte[] key, String cipherAlgorithm) {
        Key k = AesEncryptUtils.toKey(key);
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(2, k);
            if (ECB_NO_PADDING.equals(cipherAlgorithm)) {
                return AesEncryptUtils.removeZeroPadding(cipher.doFinal(data), cipher.getBlockSize());
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("AES decrypt error", e);
        }
    }

    private static byte[] formatWithZeroPadding(byte[] data, int blockSize) {
        int length = data.length;
        int remainLength = length % blockSize;
        if (remainLength > 0) {
            byte[] inputData = new byte[length + blockSize - remainLength];
            System.arraycopy(data, 0, inputData, 0, length);
            return inputData;
        }
        return data;
    }

    private static byte[] removeZeroPadding(byte[] data, int blockSize) {
        int length = data.length;
        int remainLength = length % blockSize;
        if (remainLength == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            byte[] outputData = new byte[i + 1];
            System.arraycopy(data, 0, outputData, 0, outputData.length);
            return outputData;
        }
        return data;
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes = AesEncryptUtils.initKey();
        String aesKey = "d86d7bab3d6ac01ad9dc6a897652f2d2";
        String content = "\u4f60\u597d";
        System.out.println("\u52a0\u5bc6\u524d\uff1a" + content);
        String encrypt = AesEncryptUtils.aesEncrypt(content, aesKey);
        System.out.println(encrypt.length() + ":\u52a0\u5bc6\u540e\uff1a" + encrypt);
        String decrypt = AesEncryptUtils.aesDecrypt(encrypt, aesKey);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + decrypt);
    }
}

