/*
 * Decompiled with CFR 0.152.
 */
package com.cxytiandi.encrypt.util;

import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestUriUtils {
    private static String separator = "/";

    public static String getApiUri(Class<?> clz, Method method, String contextPath) {
        String methodType = "";
        StringBuilder uri = new StringBuilder();
        RequestMapping reqMapping = (RequestMapping)AnnotationUtils.findAnnotation(clz, RequestMapping.class);
        if (reqMapping != null && reqMapping.value() != null && reqMapping.value().length > 0) {
            uri.append(RequestUriUtils.formatUri(reqMapping.value()[0]));
        }
        GetMapping getMapping = (GetMapping)AnnotationUtils.findAnnotation((Method)method, GetMapping.class);
        PostMapping postMapping = (PostMapping)AnnotationUtils.findAnnotation((Method)method, PostMapping.class);
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        PutMapping putMapping = (PutMapping)AnnotationUtils.findAnnotation((Method)method, PutMapping.class);
        DeleteMapping deleteMapping = (DeleteMapping)AnnotationUtils.findAnnotation((Method)method, DeleteMapping.class);
        if (getMapping != null && getMapping.value() != null && getMapping.value().length > 0) {
            methodType = "get:";
            uri.append(RequestUriUtils.formatUri(getMapping.value()[0]));
        } else if (postMapping != null && postMapping.value() != null && postMapping.value().length > 0) {
            methodType = "post:";
            uri.append(RequestUriUtils.formatUri(postMapping.value()[0]));
        } else if (putMapping != null && putMapping.value() != null && putMapping.value().length > 0) {
            methodType = "put:";
            uri.append(RequestUriUtils.formatUri(putMapping.value()[0]));
        } else if (deleteMapping != null && deleteMapping.value() != null && deleteMapping.value().length > 0) {
            methodType = "delete:";
            uri.append(RequestUriUtils.formatUri(deleteMapping.value()[0]));
        } else if (requestMapping != null && requestMapping.value() != null && requestMapping.value().length > 0) {
            RequestMethod requestMethod = RequestMethod.GET;
            if (requestMapping.method().length > 0) {
                requestMethod = requestMapping.method()[0];
            }
            methodType = requestMethod.name().toLowerCase() + ":";
            uri.append(RequestUriUtils.formatUri(requestMapping.value()[0]));
        }
        if (StringUtils.hasText((String)contextPath) && !separator.equals(contextPath)) {
            if (contextPath.endsWith(separator)) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            return methodType + contextPath + uri.toString();
        }
        return methodType + uri.toString();
    }

    private static String formatUri(String uri) {
        if (uri.startsWith(separator)) {
            return uri;
        }
        return separator + uri;
    }
}

