/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.PostgisWkbEncoder;
import org.geolatte.geom.codec.WkbVisitor;

public class DmWkbEncoder
extends PostgisWkbEncoder {
    protected <P extends Position> int calculateSize(Geometry<P> geom, boolean includeSrid) {
        int size = super.calculateSize(geom, includeSrid);
        return includeSrid && geom.getSRID() > 0 ? size - 4 : size;
    }

    protected <P extends Position> WkbVisitor<P> newWkbVisitor(ByteBuffer output, Geometry<P> geom) {
        return new DmWkbVisitor(output);
    }

    private static class DmWkbVisitor<P extends Position>
    extends WkbVisitor<P> {
        DmWkbVisitor(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        protected void writeTypeCodeAndSrid(Geometry<P> geometry, ByteBuffer output) {
            int typeCode = this.getGeometryType(geometry);
            output.putUInt((long)typeCode);
        }
    }
}

