/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.identity.DMIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.internal.SQLStateConverter;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.hql.spi.id.IdTableSupport;
import org.hibernate.hql.spi.id.IdTableSupportStandardImpl;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.global.GlobalTemporaryTableBulkIdStrategy;
import org.hibernate.hql.spi.id.local.AfterUseAction;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class DmDialect
extends Dialect {
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow((RowSelection)selection);
            sql = sql.trim();
            while (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            boolean isForUpdate = false;
            if (sql.toLowerCase().endsWith(" for update")) {
                sql = sql.substring(0, sql.length() - 11);
                isForUpdate = true;
            }
            StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
            if (hasOffset) {
                pagingSelect.append(sql).append(" limit ? offset ? ");
            } else {
                pagingSelect.append(sql).append(" limit ? ");
            }
            if (isForUpdate) {
                pagingSelect.append(" for update");
            }
            return pagingSelect.toString();
        }

        public boolean supportsLimit() {
            return true;
        }

        public boolean supportsLimitOffset() {
            return this.supportsLimit();
        }

        public boolean supportsVariableLimit() {
            return this.supportsLimit();
        }

        public boolean bindLimitParametersInReverseOrder() {
            return true;
        }

        public boolean bindLimitParametersFirst() {
            return false;
        }

        public boolean useMaxForLimit() {
            return false;
        }

        public boolean forceLimitUsage() {
            return false;
        }

        public int convertToFirstRowValue(int zeroBasedFirstResult) {
            return zeroBasedFirstResult;
        }
    };
    int dmdbtype_cursor = 120;
    private static final ViolatedConstraintNameExtracter EXTRACTER = new ViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sqle) {
            return null;
        }
    };

    public DmDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, "image");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "text");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(-15, "char(1)");
        this.registerColumnType(-9, "varchar($l)");
        this.registerColumnType(-16, "text");
        this.registerColumnType(2011, "clob");
        this.registerKeyword("last");
        this.registerKeyword("size");
        this.registerHibernateType(5, StandardBasicTypes.SHORT.getName());
        this.registerFunction("substring", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "substring(?1, ?2, ?3)"));
        this.registerFunction("locate", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "locate(?1, ?2, ?3)"));
        this.registerFunction("trim", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "trim(?1 ?2 ?3 ?4)"));
        this.registerFunction("length", (SQLFunction)new StandardSQLFunction("length", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("bit_length", (SQLFunction)new StandardSQLFunction("bit_length", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("coalesce", (SQLFunction)new StandardSQLFunction("coalesce"));
        this.registerFunction("nullif", (SQLFunction)new StandardSQLFunction("nullif"));
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod", (Type)StandardBasicTypes.LONG));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("cast", (SQLFunction)new CastFunction());
        this.registerFunction("extract", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "extract(?1 ?2 ?3)"));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("day", (SQLFunction)new StandardSQLFunction("day", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("str", (SQLFunction)new StandardSQLFunction("to_char", (Type)StandardBasicTypes.STRING));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceil", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cosh", (SQLFunction)new StandardSQLFunction("cosh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees"));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("GREATEST", (SQLFunction)new StandardSQLFunction("GREATEST", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction("ln", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians"));
        this.registerFunction("rand", (SQLFunction)new NoArgSQLFunction("rand", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sinh", (SQLFunction)new StandardSQLFunction("sinh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tanh", (SQLFunction)new StandardSQLFunction("tanh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("truncate", (SQLFunction)new StandardSQLFunction("truncate"));
        this.registerFunction("stddev", (SQLFunction)new StandardSQLFunction("stddev", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("variance", (SQLFunction)new StandardSQLFunction("variance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "", "||", ""));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("char_length", (SQLFunction)new StandardSQLFunction("char_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("character_length", (SQLFunction)new StandardSQLFunction("character_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap", (Type)StandardBasicTypes.STRING));
        this.registerFunction("insert", (SQLFunction)new StandardSQLFunction("insert", (Type)StandardBasicTypes.STRING));
        this.registerFunction("insstr", (SQLFunction)new StandardSQLFunction("insstr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("instr", (SQLFunction)new StandardSQLFunction("instr", (Type)StandardBasicTypes.LONG));
        this.registerFunction("instrb", (SQLFunction)new StandardSQLFunction("instrb", (Type)StandardBasicTypes.LONG));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase", (Type)StandardBasicTypes.STRING));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left", (Type)StandardBasicTypes.STRING));
        this.registerFunction("leftstr", (SQLFunction)new StandardSQLFunction("leftstr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("len", (SQLFunction)new StandardSQLFunction("len", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("LENGTHB", (SQLFunction)new StandardSQLFunction("LENGTHB", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction("octet_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim", (Type)StandardBasicTypes.STRING));
        this.registerFunction("position", (SQLFunction)new StandardSQLFunction("position", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("INS", (SQLFunction)new StandardSQLFunction("INS", (Type)StandardBasicTypes.STRING));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)StandardBasicTypes.STRING));
        this.registerFunction("REPLICATE", (SQLFunction)new StandardSQLFunction("REPLICATE", (Type)StandardBasicTypes.STRING));
        this.registerFunction("STUFF", (SQLFunction)new StandardSQLFunction("STUFF", (Type)StandardBasicTypes.STRING));
        this.registerFunction("repeatstr", (SQLFunction)new StandardSQLFunction("repeatstr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)StandardBasicTypes.STRING));
        this.registerFunction("reverse", (SQLFunction)new StandardSQLFunction("reverse", (Type)StandardBasicTypes.STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)StandardBasicTypes.STRING));
        this.registerFunction("rightstr", (SQLFunction)new StandardSQLFunction("rightstr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)StandardBasicTypes.STRING));
        this.registerFunction("TO_NUMBER", (SQLFunction)new StandardSQLFunction("TO_NUMBER"));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim", (Type)StandardBasicTypes.STRING));
        this.registerFunction("soundex", (SQLFunction)new StandardSQLFunction("soundex", (Type)StandardBasicTypes.STRING));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)StandardBasicTypes.STRING));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("substrb", (SQLFunction)new StandardSQLFunction("substrb", (Type)StandardBasicTypes.STRING));
        this.registerFunction("to_char", (SQLFunction)new StandardSQLFunction("to_char", (Type)StandardBasicTypes.STRING));
        this.registerFunction("STRPOSDEC", (SQLFunction)new StandardSQLFunction("STRPOSDEC", (Type)StandardBasicTypes.STRING));
        this.registerFunction("STRPOSINC", (SQLFunction)new StandardSQLFunction("STRPOSINC", (Type)StandardBasicTypes.STRING));
        this.registerFunction("VSIZE", (SQLFunction)new StandardSQLFunction("VSIZE", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase", (Type)StandardBasicTypes.STRING));
        this.registerFunction("OVERLAPS", (SQLFunction)new StandardSQLFunction("OVERLAPS"));
        this.registerFunction("DATEPART", (SQLFunction)new StandardSQLFunction("DATEPART"));
        this.registerFunction("DATE_PART", (SQLFunction)new StandardSQLFunction("DATE_PART"));
        this.registerFunction("add_days", (SQLFunction)new StandardSQLFunction("add_days"));
        this.registerFunction("add_months", (SQLFunction)new StandardSQLFunction("add_months"));
        this.registerFunction("add_weeks", (SQLFunction)new StandardSQLFunction("add_weeks"));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)StandardBasicTypes.DATE));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)StandardBasicTypes.TIME));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("current_date", (Type)StandardBasicTypes.DATE));
        this.registerFunction("current_time", (SQLFunction)new NoArgSQLFunction("current_time", (Type)StandardBasicTypes.TIME));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current_timestamp", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("dateadd", (SQLFunction)new StandardSQLFunction("dateadd", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("CUR_TICK_TIME", (SQLFunction)new StandardSQLFunction("CUR_TICK_TIME"));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction("datediff", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("datepart", (SQLFunction)new StandardSQLFunction("datepart", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)StandardBasicTypes.STRING));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("days_between", (SQLFunction)new StandardSQLFunction("days_between", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("getdate", (SQLFunction)new StandardSQLFunction("getdate", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("LOCALTIMESTAMP", (SQLFunction)new StandardSQLFunction("LOCALTIMESTAMP"));
        this.registerFunction("NOW", (SQLFunction)new StandardSQLFunction("NOW"));
        this.registerFunction("last_day", (SQLFunction)new StandardSQLFunction("last_day"));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)StandardBasicTypes.STRING));
        this.registerFunction("months_between", (SQLFunction)new StandardSQLFunction("months_between"));
        this.registerFunction("GREATEST", (SQLFunction)new StandardSQLFunction("GREATEST", (Type)StandardBasicTypes.DATE));
        this.registerFunction("TO_DATETIME", (SQLFunction)new StandardSQLFunction("TO_DATETIME"));
        this.registerFunction("next_day", (SQLFunction)new StandardSQLFunction("next_day"));
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction("quarter", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("timestampadd", (SQLFunction)new StandardSQLFunction("timestampadd", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("timestampdiff", (SQLFunction)new StandardSQLFunction("timestampdiff", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("BIGDATEDIFF", (SQLFunction)new StandardSQLFunction("BIGDATEDIFF", (Type)StandardBasicTypes.BIG_INTEGER));
        this.registerFunction("sysdate", (SQLFunction)new StandardSQLFunction("sysdate", (Type)StandardBasicTypes.TIME));
        this.registerFunction("LEAST", (SQLFunction)new StandardSQLFunction("LEAST"));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("weekday", (SQLFunction)new StandardSQLFunction("weekday", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("weeks_between", (SQLFunction)new StandardSQLFunction("weeks_between", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("years_between", (SQLFunction)new StandardSQLFunction("years_between", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("to_date", (SQLFunction)new StandardSQLFunction("to_date", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("systimestamp", (SQLFunction)new NoArgSQLFunction("systimestamp", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("ifnull", (SQLFunction)new StandardSQLFunction("ifnull"));
        this.registerFunction("isnull", (SQLFunction)new StandardSQLFunction("isnull"));
        this.registerFunction("nvl", (SQLFunction)new StandardSQLFunction("nvl"));
        this.registerFunction("decode", (SQLFunction)new StandardSQLFunction("decode"));
        this.registerFunction("cur_database", (SQLFunction)new StandardSQLFunction("cur_database", (Type)StandardBasicTypes.STRING));
        this.registerFunction("page", (SQLFunction)new StandardSQLFunction("page", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("sessid", (SQLFunction)new StandardSQLFunction("sessid", (Type)StandardBasicTypes.LONG));
        this.registerFunction("uid", (SQLFunction)new StandardSQLFunction("uid", (Type)StandardBasicTypes.LONG));
        this.registerFunction("user", (SQLFunction)new StandardSQLFunction("user", (Type)StandardBasicTypes.STRING));
        this.registerFunction("vsize", (SQLFunction)new StandardSQLFunction("vsize", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("tabledef", (SQLFunction)new StandardSQLFunction("tabledef", (Type)StandardBasicTypes.STRING));
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return new DMIdentityColumnSupport();
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName);
    }

    public String getSelectSequenceNextValString(String sequenceName) {
        return String.valueOf(sequenceName) + ".nextval";
    }

    public String[] getCreateSequenceStrings(String sequenceName) {
        return new String[]{this.getCreateSequenceString(sequenceName)};
    }

    public String[] getCreateSequenceStrings(String sequenceName, int initialValue, int incrementSize) {
        return new String[]{this.getCreateSequenceString(sequenceName, initialValue, incrementSize)};
    }

    protected String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    protected String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) {
        return String.valueOf(this.getCreateSequenceString(sequenceName)) + " increment by " + incrementSize + " start with " + initialValue;
    }

    public String[] getDropSequenceStrings(String sequenceName) {
        return new String[]{this.getDropSequenceString(sequenceName)};
    }

    protected String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getQuerySequencesString() {
        return "select\r\n        SEQS.SEQUENCE_NAME NAME,\r\n        SEQS.*                        ,\r\n        '' sequence_catalog           ,\r\n        sequence_owner sequence_schema,\r\n        SEQ_OBJ.INFO3 start_value     ,\r\n        min_value minimum_value       ,\r\n        max_value maximum_value       ,\r\n        increment_by increment      ,\r\n        SEQ_OBJ.ID\r\nfrom\r\n        all_sequences SEQS\r\nleft join\r\n        (\r\n                select distinct\r\n                        SCH_OBJ.NAME SCHEMA_NAME,\r\n                        SEQ_OBJ_INNER.ID        ,\r\n                        SEQ_OBJ_INNER.NAME      ,\r\n                        SEQ_OBJ_INNER.INFO3\r\n                from\r\n                        SYS.SYSOBJECTS SEQ_OBJ_INNER,\r\n                        SYS.SYSOBJECTS SCH_OBJ\r\n                where\r\n                        SCH_OBJ.TYPE$          ='SCH'\r\n                    and SEQ_OBJ_INNER.SUBTYPE$ ='SEQ'\r\n                    and SEQ_OBJ_INNER.SCHID    = SCH_OBJ.ID\r\n        )\r\n        SEQ_OBJ\r\nON\r\n        SEQ_OBJ.NAME        = SEQS.SEQUENCE_NAME\r\n    AND SEQ_OBJ.SCHEMA_NAME = SEQS.SEQUENCE_OWNER";
    }

    public String getSelectGUIDString() {
        return "select GUID()";
    }

    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex != selectIndex ? 6 : 15);
    }

    public boolean supportsLockTimeouts() {
        return true;
    }

    public boolean isLockTimeoutParameterized() {
        return false;
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int timeout) {
        if (timeout == 0) {
            return " for update nowait";
        }
        if (timeout > 0) {
            float seconds = (float)timeout / 1000.0f;
            timeout = Math.round(seconds);
            return " for update wait " + timeout;
        }
        return " for update";
    }

    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return String.valueOf(this.getForUpdateString()) + " of " + aliases;
    }

    public String getForUpdateNowaitString() {
        return String.valueOf(this.getForUpdateString()) + " nowait";
    }

    public String getForUpdateNowaitString(String aliases) {
        return String.valueOf(this.getForUpdateString()) + " of " + aliases + " nowait";
    }

    public String appendLockHint(LockMode mode, String tableName) {
        return tableName;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        if (this.dmdbtype_cursor == 0) {
            try {
                Class types = ReflectHelper.classForName((String)"dm.jdbc.driver.DmdbType");
                this.dmdbtype_cursor = types.getField("CURSOR").getInt(types.newInstance());
            }
            catch (Exception se) {
                throw new SQLException("Problem while trying to load or access DmdbType.CURSOR value", se);
            }
        }
        statement.registerOutParameter(col, this.dmdbtype_cursor);
        return ++col;
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        if (this.dmdbtype_cursor == 0) {
            try {
                Class types = ReflectHelper.classForName((String)"dm.jdbc.driver.DmdbType");
                this.dmdbtype_cursor = types.getField("CURSOR").getInt(types.newInstance());
            }
            catch (Exception se) {
                throw new SQLException("Problem while trying to load or access DmdbType.CURSOR value", se);
            }
        }
        statement.registerOutParameter(name, this.dmdbtype_cursor);
        return 1;
    }

    public ResultSet getResultSet(CallableStatement statement) throws SQLException {
        statement.execute();
        return (ResultSet)statement.getObject(1);
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        return (ResultSet)statement.getObject(position);
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        return (ResultSet)statement.getObject(name);
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp()";
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new SQLStateConverter(this.getViolatedConstraintNameExtracter());
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public String getSelectClauseNullString(int sqlType) {
        return "null";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String transformSelectString(String select) {
        return select;
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean supportsUnique() {
        return true;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public String getAddColumnString() {
        return " add column ";
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getTableTypeString() {
        return "";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuffer res = new StringBuffer(30);
        res.append(" add constraint ").append(constraintName).append(" foreign key (").append(this.join(", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(this.join(", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String comment) {
        return "";
    }

    public String getColumnComment(String comment) {
        return "";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsNotNullUnique() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return " cascade ";
    }

    public String getCrossJoinSeparator() {
        return " cross join ";
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public boolean replaceResultVariableInOrderByClauseWithPosition() {
        return false;
    }

    public boolean requiresCastingOfParametersInSelectClause() {
        return false;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return true;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return true;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return true;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public boolean supportsBindAsCallableArgument() {
        return true;
    }

    public boolean supportsTupleCounts() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public MultiTableBulkIdStrategy getDefaultMultiTableBulkIdStrategy() {
        return new GlobalTemporaryTableBulkIdStrategy((IdTableSupport)new IdTableSupportStandardImpl(){

            public String generateIdTableName(String baseName) {
                String name = super.generateIdTableName(baseName);
                return name.length() > 30 ? name.substring(0, 30) : name;
            }

            public String getCreateIdTableCommand() {
                return "create global temporary table";
            }

            public String getCreateIdTableStatementOptions() {
                return "on commit delete rows";
            }
        }, AfterUseAction.CLEAN);
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    private String join(String seperator, String[] strings) {
        int length = strings.length;
        if (length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(length * strings[0].length()).append(strings[0]);
        int i = 1;
        while (i < length) {
            buf.append(seperator).append(strings[i]);
            ++i;
        }
        return buf.toString();
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }
}

