/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import java.util.concurrent.atomic.AtomicBoolean;

public class SkipOnConcurrentExecutionDecorator
implements Runnable {
    private final AtomicBoolean isAlreadyRunning = new AtomicBoolean();
    private final Runnable runnable;

    public SkipOnConcurrentExecutionDecorator(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void run() {
        if (this.isAlreadyRunning.compareAndSet(false, true)) {
            try {
                this.runnable.run();
            }
            finally {
                this.isAlreadyRunning.set(false);
            }
        }
    }
}

