/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.text.Image;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.filters.ImageFilter;
import java.awt.event.ActionEvent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ImageArgument
extends AbstractArgument {
    private FileFilter filter;

    public ImageArgument(AbstractTool tool, String name, String description, FileFilter filter) {
        super(tool, name, description, null);
        this.filter = filter;
    }

    public ImageArgument(AbstractTool tool, String name, String description) {
        this(tool, name, description, new ImageFilter());
    }

    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return Image.getInstance(this.value.toString());
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        if (this.filter != null) {
            fc.setFileFilter(this.filter);
        }
        fc.showOpenDialog(this.tool.getInternalFrame());
        try {
            this.setValue(fc.getSelectedFile().getAbsolutePath());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

