/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client;

import com.netflix.client.ClientException;
import com.netflix.client.ClientRequest;
import com.netflix.client.IClient;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.IResponse;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.ServerOperation;
import java.net.URI;
import rx.Observable;

public abstract class AbstractLoadBalancerAwareClient<S extends ClientRequest, T extends IResponse>
extends LoadBalancerContext
implements IClient<S, T>,
IClientConfigAware {
    public AbstractLoadBalancerAwareClient(ILoadBalancer lb) {
        super(lb);
    }

    public AbstractLoadBalancerAwareClient(ILoadBalancer lb, IClientConfig clientConfig) {
        super(lb, clientConfig);
    }

    @Deprecated
    protected boolean isCircuitBreakerException(Throwable e) {
        if (this.getRetryHandler() != null) {
            return this.getRetryHandler().isCircuitTrippingException(e);
        }
        return false;
    }

    @Deprecated
    protected boolean isRetriableException(Throwable e) {
        if (this.getRetryHandler() != null) {
            return this.getRetryHandler().isRetriableException(e, true);
        }
        return false;
    }

    public T executeWithLoadBalancer(S request) throws ClientException {
        return this.executeWithLoadBalancer(request, null);
    }

    public T executeWithLoadBalancer(S request, IClientConfig requestConfig) throws ClientException {
        LoadBalancerCommand<T> command = this.buildLoadBalancerCommand(request, requestConfig);
        try {
            return (T)((IResponse)command.submit(new ServerOperation<T>((ClientRequest)request, requestConfig){
                final /* synthetic */ ClientRequest val$request;
                final /* synthetic */ IClientConfig val$requestConfig;
                {
                    this.val$request = clientRequest;
                    this.val$requestConfig = iClientConfig;
                }

                @Override
                public Observable<T> call(Server server) {
                    URI finalUri = AbstractLoadBalancerAwareClient.this.reconstructURIWithServer(server, this.val$request.getUri());
                    ClientRequest requestForServer = this.val$request.replaceUri(finalUri);
                    try {
                        return Observable.just((Object)AbstractLoadBalancerAwareClient.this.execute(requestForServer, this.val$requestConfig));
                    }
                    catch (Exception e) {
                        return Observable.error((Throwable)e);
                    }
                }
            }).toBlocking().single());
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof ClientException) {
                throw (ClientException)t;
            }
            throw new ClientException((Throwable)e);
        }
    }

    public abstract RequestSpecificRetryHandler getRequestSpecificRetryHandler(S var1, IClientConfig var2);

    protected LoadBalancerCommand<T> buildLoadBalancerCommand(S request, IClientConfig config) {
        RequestSpecificRetryHandler handler = this.getRequestSpecificRetryHandler(request, config);
        LoadBalancerCommand.Builder builder = LoadBalancerCommand.builder().withLoadBalancerContext(this).withRetryHandler((RetryHandler)handler).withLoadBalancerURI(request.getUri());
        this.customizeLoadBalancerCommandBuilder(request, config, builder);
        return builder.build();
    }

    protected void customizeLoadBalancerCommandBuilder(S request, IClientConfig config, LoadBalancerCommand.Builder<T> builder) {
    }

    @Deprecated
    protected boolean isRetriable(S request) {
        if (request.isRetriable()) {
            return true;
        }
        boolean retryOkayOnOperation = this.okToRetryOnAllOperations;
        IClientConfig overriddenClientConfig = request.getOverrideConfig();
        if (overriddenClientConfig != null) {
            retryOkayOnOperation = overriddenClientConfig.getPropertyAsBoolean(CommonClientConfigKey.RequestSpecificRetryOn, this.okToRetryOnAllOperations);
        }
        return retryOkayOnOperation;
    }
}

