/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.exception;

import com.qcloud.cos.exception.CosClientException;
import java.util.Map;

public class CosServiceException
extends CosClientException {
    private static final long serialVersionUID = 1L;
    private String requestId;
    private String errorCode;
    private ErrorType errorType = ErrorType.Unknown;
    private String errorMessage;
    private int statusCode;
    private String rawResponseContent;
    private String traceId;
    private Map<String, String> additionalDetails;
    private final String errorResponseXml;

    public CosServiceException(String errorMessage) {
        super((String)null);
        this.errorMessage = errorMessage;
        this.errorResponseXml = null;
    }

    public CosServiceException(String errorMessage, Exception cause) {
        super(null, cause);
        this.errorMessage = errorMessage;
        this.errorResponseXml = null;
    }

    public CosServiceException(String message, String errorResponseXml) {
        super((String)null);
        this.errorMessage = message;
        if (errorResponseXml == null) {
            throw new IllegalArgumentException("Error Response XML cannot be null");
        }
        this.errorResponseXml = errorResponseXml;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String value) {
        this.errorMessage = value;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String tranceId) {
        this.traceId = tranceId;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(Map<String, String> additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public String getErrorResponseXml() {
        return this.errorResponseXml;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage() + " (Status Code: " + this.getStatusCode() + "; Error Code: " + this.getErrorCode() + "; Request ID: " + this.getRequestId() + ")" + "; Trace ID: " + this.getTraceId();
    }

    public String getRawResponseContent() {
        return this.rawResponseContent;
    }

    public void setRawResponseContent(String rawResponseContent) {
        this.rawResponseContent = rawResponseContent;
    }

    public static enum ErrorType {
        Client,
        Service,
        Unknown;

    }
}

