/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.CredentialsEndpointProvider;
import com.qcloud.cos.auth.InstanceCredentialsUtils;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.Jackson;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPMCredentialsFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(CPMCredentialsFetcher.class);
    private static final int REFRESH_THRESHOLD = 3600000;
    private static final int EXPIRATION_THRESHOLD = 600000;
    private static final String SECRET_ID = "TmpSecretId";
    private static final String SECRET_KEY = "TmpSecretKey";
    private static final String TOKEN = "Token";
    private static final String EXPIRATION = "Expiration";
    private volatile COSCredentials cosCredentials;
    private volatile Date credentialExpiration;
    private volatile Date lastInstanceProfileCheck;
    private CredentialsEndpointProvider credentialsEndpointProvider;

    public CPMCredentialsFetcher(CredentialsEndpointProvider credentialsEndpointProvider) {
        if (null == credentialsEndpointProvider) {
            this.handleError("The credentials endpoint provider can not be null.", null);
        }
        this.credentialsEndpointProvider = credentialsEndpointProvider;
    }

    public COSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.fetchCredentials();
        }
        if (this.expired()) {
            throw new CosClientException("The credentials received have been expired");
        }
        return this.cosCredentials;
    }

    protected boolean needsToLoadCredentials() {
        if (null == this.cosCredentials) {
            return true;
        }
        if (null != this.credentialExpiration && this.isWithinExpirationThreshold()) {
            return true;
        }
        if (null != this.lastInstanceProfileCheck) {
            return this.isPastRefreshThreshold();
        }
        return false;
    }

    private synchronized void fetchCredentials() {
        if (!this.needsToLoadCredentials()) {
            return;
        }
        try {
            this.lastInstanceProfileCheck = new Date();
            String credentialsResponse = InstanceCredentialsUtils.getInstance().readResource(this.credentialsEndpointProvider.getCredentialsEndpoint(), this.credentialsEndpointProvider.getRetryPolicy(), this.credentialsEndpointProvider.getHeaders());
            JsonNode node = Jackson.fromSensitiveJsonString(credentialsResponse, JsonNode.class);
            JsonNode secretId = node.get(SECRET_ID);
            JsonNode secretKey = node.get(SECRET_KEY);
            JsonNode token = node.get(TOKEN);
            if (null == secretId || null == secretKey) {
                throw new CosClientException("Unable to load credentials");
            }
            this.cosCredentials = null != token ? new BasicSessionCredentials(secretId.asText(), secretKey.asText(), token.asText()) : new BasicCOSCredentials(secretId.asText(), secretKey.asText());
            JsonNode expirationJsonNode = node.get(EXPIRATION);
            if (null != expirationJsonNode) {
                String expiration = expirationJsonNode.asText();
                try {
                    this.credentialExpiration = DateUtils.parseISO8601Date(expiration);
                }
                catch (Exception e) {
                    String exceptionMessage = String.format("Unable to parse the credentials expiration date [%s] from CPM instance.", expiration);
                    this.handleError(exceptionMessage, e);
                }
            }
        }
        catch (JsonMappingException e) {
            this.handleError("Unable to parse the returned from service endpoint.", (Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleError("Unable to load the credentials from service endpoint.", e);
        }
        catch (URISyntaxException e) {
            this.handleError("Unable to load the credentials from service endpoint.", e);
        }
    }

    public void refresh() {
        this.cosCredentials = null;
    }

    private boolean expired() {
        return null != this.credentialExpiration && this.credentialExpiration.getTime() < System.currentTimeMillis();
    }

    private boolean isWithinExpirationThreshold() {
        return this.credentialExpiration.getTime() - System.currentTimeMillis() < 600000L;
    }

    private boolean isPastRefreshThreshold() {
        return System.currentTimeMillis() - this.lastInstanceProfileCheck.getTime() > 3600000L;
    }

    private void handleError(String errorMessage, Exception e) {
        if (null == this.cosCredentials || this.expired()) {
            if (null == errorMessage && null == e) {
                return;
            }
            if (null != errorMessage && null == e) {
                throw new CosClientException(errorMessage);
            }
            if (null == errorMessage && null != e) {
                throw new CosClientException(e);
            }
            throw new CosClientException(errorMessage, e);
        }
        LOG.warn(errorMessage, (Throwable)e);
    }
}

