/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.auth.CVMCredentialsFetcher;
import com.qcloud.cos.auth.CVMMetadataUtils;
import com.qcloud.cos.auth.CredentialsEndpointProvider;
import com.qcloud.cos.auth.InstanceCredentialsUtils;
import com.qcloud.cos.exception.CosClientException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVMInstanceProfileCredentialsProvider
implements COSCredentialsProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CVMInstanceProfileCredentialsProvider.class);
    private static final int ASYNC_REFRESH_INTERVAL_TIME_MINUTES = 1;
    private static final CVMInstanceProfileCredentialsProvider INSTANCE = new CVMInstanceProfileCredentialsProvider();
    private final CVMCredentialsFetcher cvmCredentialsFetcher = new CVMCredentialsFetcher(new InstanceMetadataCredentialsEndpointProvider());
    private volatile ScheduledExecutorService executorService;
    private volatile boolean shouldRefresh = false;

    public static CVMInstanceProfileCredentialsProvider getInstance() {
        return INSTANCE;
    }

    private CVMInstanceProfileCredentialsProvider() {
        this(false);
    }

    private CVMInstanceProfileCredentialsProvider(boolean refreshCredentialsAsync) {
        if (refreshCredentialsAsync) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("cvm-instance-profile-credentials-refresh");
                    t.setDaemon(true);
                    return t;
                }
            });
            this.executorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (CVMInstanceProfileCredentialsProvider.this.shouldRefresh) {
                            CVMInstanceProfileCredentialsProvider.this.cvmCredentialsFetcher.getCredentials();
                        }
                    }
                    catch (CosClientException e) {
                        CVMInstanceProfileCredentialsProvider.this.handleError(e);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
    }

    public static CVMInstanceProfileCredentialsProvider createAsyncRefreshingProvider() {
        return new CVMInstanceProfileCredentialsProvider(true);
    }

    @Override
    public COSCredentials getCredentials() {
        COSCredentials cosCredentials = this.cvmCredentialsFetcher.getCredentials();
        this.shouldRefresh = true;
        return cosCredentials;
    }

    @Override
    public void refresh() {
        if (null != this.cvmCredentialsFetcher) {
            this.cvmCredentialsFetcher.refresh();
        }
    }

    @Override
    public void close() throws IOException {
        if (null != this.executorService) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (null != this.executorService) {
            this.executorService.shutdownNow();
        }
    }

    private void handleError(Throwable t) {
        this.refresh();
        LOG.error(t.getMessage(), t);
    }

    private static class InstanceMetadataCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        private InstanceMetadataCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() throws URISyntaxException, IOException {
            String host = CVMMetadataUtils.getHostAddressForCVMMetadataService();
            String securityCredentialsList = InstanceCredentialsUtils.getInstance().readResource(new URI(host + "/meta-data" + "/cam/security-credentials"));
            String[] securityCredentials = securityCredentialsList.trim().split("\n");
            if (securityCredentials.length == 0) {
                throw new CosClientException("Unable to load the credentials path. No invalid security credentials were found");
            }
            return new URI(host + "/meta-data" + "/cam/security-credentials" + "/" + securityCredentials[0]);
        }
    }
}

