/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.qcloud.cos.auth.InstanceCredentialsUtils;
import com.qcloud.cos.exception.CosClientException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVMMetadataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CVMMetadataUtils.class);
    public static final String CVM_METADATA_SERVICE_URL = "http://metadata.tencentyun.com";
    public static final String CVM_METADATA_ROOT = "/meta-data";
    public static final String SECURITY_CREDENTIALS_RESOURCE = "/cam/security-credentials";
    private static final int DEFAULT_QUERY_RETRIES = 3;
    private static final int MINIMUM_WAIT_TIME_MILLISECONDS = 250;
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Map<String, CAMSecurityCredential> getCAMSecurityCredentials() {
        HashMap<String, CAMSecurityCredential> credentialMap = new HashMap<String, CAMSecurityCredential>();
        List<String> credentials = CVMMetadataUtils.getItems("/meta-data/cam/security-credentials");
        if (null != credentials) {
            for (String credential : credentials) {
                String json = CVMMetadataUtils.getData("/meta-data/cam/security-credentials/" + credential);
                if (null == json) continue;
                try {
                    CAMSecurityCredential camSecurityCredential = (CAMSecurityCredential)mapper.readValue(json, CAMSecurityCredential.class);
                    credentialMap.put(credential, camSecurityCredential);
                }
                catch (Exception e) {
                    LOG.warn("Unable to process the credential (" + credential + "). " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return credentialMap;
    }

    public static String getData(String path) {
        return CVMMetadataUtils.getData(path, 3);
    }

    public static String getData(String path, int tries) {
        List<String> items = CVMMetadataUtils.getItems(path, tries, true);
        if (null != items && items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public static List<String> getItems(String path) {
        return CVMMetadataUtils.getItems(path, 3, false);
    }

    public static List<String> getItems(String path, int retries) {
        return CVMMetadataUtils.getItems(path, retries, false);
    }

    public static List<String> getItems(String path, int retries, boolean slurp) {
        List<String> items = null;
        for (int i = 0; i <= retries; ++i) {
            try {
                String response = InstanceCredentialsUtils.getInstance().readResource(new URI(CVMMetadataUtils.getHostAddressForCVMMetadataService() + path));
                if (slurp) {
                    items = Collections.singletonList(response);
                    break;
                }
                items = Arrays.asList(response.split("\n"));
                break;
            }
            catch (CosClientException e) {
                LOG.error("Unable to retrieve the requested metadata (" + path + "). " + e.getMessage(), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                try {
                    CVMMetadataUtils.retryWait(retries);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.error("Waiting for retry to be interrupted.", (Throwable)ex);
                    break;
                }
            }
        }
        return items;
    }

    private static void retryWait(int retries) throws InterruptedException {
        long pause = (long)(Math.pow(2.0, 3 - retries) * 250.0);
        Thread.sleep(pause < 250L ? 250L : pause);
    }

    public static String getHostAddressForCVMMetadataService() {
        return CVM_METADATA_SERVICE_URL;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.PASCAL_CASE_TO_CAMEL_CASE);
    }

    public static class CAMSecurityCredential {
        public String tmpSecretId;
        public String tmpSecretKey;
        public String token;
        public long expiredTime;
        public String expiration;
        public String code;
    }
}

