/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.html.LengthTrackingAppendable;
import java.io.IOException;

public class LengthTrackingAppendableImpl
implements LengthTrackingAppendable {
    private final Appendable myAppendable;
    private int myLength;

    public LengthTrackingAppendableImpl(Appendable appendable) {
        this.myAppendable = appendable;
        this.myLength = 0;
    }

    @Override
    public int getLength() {
        return this.myLength;
    }

    @Override
    public LengthTrackingAppendable append(CharSequence csq) throws IOException {
        this.myAppendable.append(csq);
        this.myLength += csq.length();
        return this;
    }

    @Override
    public LengthTrackingAppendable append(CharSequence csq, int start, int end) throws IOException {
        this.myAppendable.append(csq, start, end);
        this.myLength += end - start;
        return this;
    }

    @Override
    public LengthTrackingAppendable append(char c) throws IOException {
        this.myAppendable.append(c);
        ++this.myLength;
        return this;
    }

    public Appendable getAppendable() {
        return this.myAppendable;
    }

    public static LengthTrackingAppendable of(Appendable appendable) {
        return new LengthTrackingAppendableImpl(appendable);
    }

    public String toString() {
        return this.myAppendable.toString();
    }
}

