/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.executor;

import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.result.MemoryQueryResult;
import io.shardingsphere.core.executor.sql.execute.result.StreamQueryResult;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareCallback;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.shardingjdbc.executor.AbstractStatementExecutor;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;

public final class StatementExecutor
extends AbstractStatementExecutor {
    public StatementExecutor(int resultSetType, int resultSetConcurrency, int resultSetHoldability, ShardingConnection shardingConnection) {
        super(resultSetType, resultSetConcurrency, resultSetHoldability, shardingConnection);
    }

    public void init(SQLRouteResult routeResult) throws SQLException {
        this.getExecuteGroups().addAll(this.obtainExecuteGroups(routeResult.getRouteUnits()));
        this.cacheStatements();
    }

    private Collection<ShardingExecuteGroup<StatementExecuteUnit>> obtainExecuteGroups(Collection<RouteUnit> routeUnits) throws SQLException {
        return this.getSqlExecutePrepareTemplate().getExecuteUnitGroups(routeUnits, new SQLExecutePrepareCallback(){

            public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
                return StatementExecutor.super.getConnection().getConnections(connectionMode, dataSourceName, connectionSize);
            }

            public StatementExecuteUnit createStatementExecuteUnit(Connection connection, RouteUnit routeUnit, ConnectionMode connectionMode) throws SQLException {
                return new StatementExecuteUnit(routeUnit, connection.createStatement(StatementExecutor.this.getResultSetType(), StatementExecutor.this.getResultSetConcurrency(), StatementExecutor.this.getResultSetHoldability()), connectionMode);
            }
        });
    }

    public List<QueryResult> executeQuery() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<QueryResult> executeCallback = new SQLExecuteCallback<QueryResult>(this.getDatabaseType(), isExceptionThrown){

            protected QueryResult executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
                return StatementExecutor.this.getQueryResult(statementExecuteUnit);
            }
        };
        return this.executeCallback(executeCallback);
    }

    private QueryResult getQueryResult(StatementExecuteUnit statementExecuteUnit) throws SQLException {
        ResultSet resultSet = statementExecuteUnit.getStatement().executeQuery(statementExecuteUnit.getRouteUnit().getSqlUnit().getSql());
        this.getResultSets().add(resultSet);
        return ConnectionMode.MEMORY_STRICTLY == statementExecuteUnit.getConnectionMode() ? new StreamQueryResult(resultSet) : new MemoryQueryResult(resultSet);
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql);
            }
        });
    }

    public int executeUpdate(final int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    public int executeUpdate(final int[] columnIndexes) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnIndexes);
            }
        });
    }

    public int executeUpdate(final String[] columnNames) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnNames);
            }
        });
    }

    private int executeUpdate(final Updater updater) throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<Integer> executeCallback = new SQLExecuteCallback<Integer>(this.getDatabaseType(), isExceptionThrown){

            protected Integer executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
                return updater.executeUpdate(statementExecuteUnit.getStatement(), statementExecuteUnit.getRouteUnit().getSqlUnit().getSql());
            }
        };
        List<Integer> results = this.executeCallback(executeCallback);
        return this.accumulate(results);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute() throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql);
            }
        });
    }

    public boolean execute(final int autoGeneratedKeys) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, autoGeneratedKeys);
            }
        });
    }

    public boolean execute(final int[] columnIndexes) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnIndexes);
            }
        });
    }

    public boolean execute(final String[] columnNames) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnNames);
            }
        });
    }

    private boolean execute(final Executor executor) throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<Boolean> executeCallback = new SQLExecuteCallback<Boolean>(this.getDatabaseType(), isExceptionThrown){

            protected Boolean executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
                return executor.execute(statementExecuteUnit.getStatement(), statementExecuteUnit.getRouteUnit().getSqlUnit().getSql());
            }
        };
        List<Boolean> result = this.executeCallback(executeCallback);
        if (null == result || result.isEmpty() || null == result.get(0)) {
            return false;
        }
        return result.get(0);
    }

    private static interface Executor {
        public boolean execute(Statement var1, String var2) throws SQLException;
    }

    private static interface Updater {
        public int executeUpdate(Statement var1, String var2) throws SQLException;
    }
}

