/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.export;

import com.google.auto.service.AutoService;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import net.biville.florent.sproccompiler.export.DsvConfiguration;
import net.biville.florent.sproccompiler.export.io.DsvSerializer;
import net.biville.florent.sproccompiler.messages.MessagePrinter;
import net.biville.florent.sproccompiler.visitors.ExecutableElementVisitor;
import net.biville.florent.sproccompiler.visitors.TypeElementVisitor;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

@AutoService(value=Processor.class)
public class DsvProcessor
extends AbstractProcessor {
    private final Collection<ExecutableElement> visitedProcedures = new LinkedHashSet<ExecutableElement>();
    private final Collection<ExecutableElement> visitedFunctions = new LinkedHashSet<ExecutableElement>();
    private ExecutableElementVisitor methodVisitor;
    private DsvConfiguration configuration;
    private DsvSerializer serializer;
    private Messager messager;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(Procedure.class.getName(), UserFunction.class.getName()));
    }

    @Override
    public Set<String> getSupportedOptions() {
        return DsvConfiguration.getSupportedOptions();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.visitedProcedures.clear();
        this.visitedFunctions.clear();
        this.messager = processingEnv.getMessager();
        this.methodVisitor = new ExecutableElementVisitor(this.messager);
        this.configuration = new DsvConfiguration(processingEnv.getOptions());
        this.serializer = new DsvSerializer(processingEnv.getElementUtils(), new TypeElementVisitor(this.messager), new MessagePrinter(this.messager));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Optional<Path> rootPath = this.configuration.getRootPath();
        if (!rootPath.isPresent()) {
            if (roundEnv.processingOver()) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Skipping export, export path option -A%s not specified", "GeneratedDocumentationPath"));
            }
            return false;
        }
        this.processSources(roundEnv, rootPath.get());
        return false;
    }

    private void processSources(RoundEnvironment roundEnv, Path root) {
        if (roundEnv.processingOver()) {
            DsvProcessor.checkExportFolder(root);
            this.serializer.serialize(root, this.configuration, this.visitedProcedures, this.visitedFunctions);
        } else {
            roundEnv.getElementsAnnotatedWith(Procedure.class).forEach(this::visitProcedure);
            roundEnv.getElementsAnnotatedWith(UserFunction.class).forEach(this::visitFunction);
        }
    }

    private void visitFunction(Element el) {
        this.visitedFunctions.add((ExecutableElement)this.methodVisitor.visit(el));
    }

    private void visitProcedure(Element el) {
        this.visitedProcedures.add((ExecutableElement)this.methodVisitor.visit(el));
    }

    private static void checkExportFolder(Path root) {
        File rootFolder = root.toFile();
        String absolutePath = rootFolder.getAbsolutePath();
        if (!rootFolder.exists() && !rootFolder.mkdirs()) {
            throw new IllegalArgumentException(String.format("Could not create export path <%s>!", absolutePath));
        }
        if (!rootFolder.isDirectory() || !rootFolder.canWrite()) {
            throw new IllegalArgumentException(String.format("Export path <%s> should be a writable directory", absolutePath));
        }
    }
}

