/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

public final class WordSplitter {
    private WordSplitter() {
    }

    public static boolean isWordSeparator(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndOfStringSeparator(char c) {
        switch (c) {
            case '(': 
            case ')': {
                return true;
            }
        }
        return false;
    }

    public static int findNextWordStart(char[] chars, int offset) {
        for (int charNr = offset; charNr < chars.length; ++charNr) {
            char theChar = chars[charNr];
            if (WordSplitter.isEndOfStringSeparator(theChar)) {
                return -1;
            }
            if (WordSplitter.isWordSeparator(theChar)) continue;
            return charNr;
        }
        return -1;
    }

    public static int findEndOfString(char[] chars, int offset) {
        for (int charNr = offset; charNr < chars.length; ++charNr) {
            char theChar = chars[charNr];
            if (!WordSplitter.isEndOfStringSeparator(theChar)) continue;
            return charNr;
        }
        return chars.length;
    }

    public static int findWordStart(char[] chars, int word) {
        if (word <= 0) {
            return -1;
        }
        int charNr = 0;
        boolean inWord = false;
        int currentWord = 0;
        for (char theChar : chars) {
            if (WordSplitter.isEndOfStringSeparator(theChar)) {
                return -1;
            }
            if (WordSplitter.isWordSeparator(theChar)) {
                if (inWord) {
                    inWord = false;
                }
            } else if (!inWord) {
                inWord = true;
                if (++currentWord == word) {
                    return charNr;
                }
            }
            ++charNr;
        }
        return -1;
    }

    public static int findWordEnd(char[] chars, int start) {
        for (int i = start; i < chars.length; ++i) {
            if (!WordSplitter.isWordSeparator(chars[i])) continue;
            return i;
        }
        return chars.length;
    }

    public static String getSingleWord(String value, int word) {
        char[] characters = value.toCharArray();
        int start = WordSplitter.findWordStart(characters, word);
        if (start == -1) {
            return null;
        }
        int end = WordSplitter.findWordEnd(characters, start);
        return value.substring(start, end);
    }

    public static String getFirstWords(String value, int word) {
        char[] characters = value.toCharArray();
        int start = WordSplitter.findWordStart(characters, word);
        if (start == -1) {
            return null;
        }
        int end = WordSplitter.findWordEnd(characters, start);
        return value.substring(0, end);
    }

    public static String getWordRange(String value, int firstWord, int lastWord) {
        if (value == null || lastWord > 0 && lastWord < firstWord) {
            return null;
        }
        char[] characters = value.toCharArray();
        int firstCharOfFirstWord = WordSplitter.findWordStart(characters, firstWord);
        if (firstCharOfFirstWord == -1) {
            return null;
        }
        if (lastWord == -1) {
            return value.substring(firstCharOfFirstWord, WordSplitter.findEndOfString(characters, firstCharOfFirstWord));
        }
        int firstCharOfLastWord = firstCharOfFirstWord;
        if (lastWord != firstWord && (firstCharOfLastWord = WordSplitter.findWordStart(characters, lastWord)) == -1) {
            return null;
        }
        int lastCharOfLastWord = WordSplitter.findWordEnd(characters, firstCharOfLastWord);
        if (lastCharOfLastWord == -1) {
            return null;
        }
        return value.substring(firstCharOfFirstWord, lastCharOfLastWord);
    }
}

