/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.saml.sso.SSOValidatorResponse;
import org.apache.cxf.rs.security.saml.sso.TokenReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLSSOResponseValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLSSOResponseValidator.class);
    private String issuerIDP;
    private String assertionConsumerURL;
    private String clientAddress;
    private String requestId;
    private String spIdentifier;
    private boolean enforceAssertionsSigned = true;
    private boolean enforceKnownIssuer = true;
    private TokenReplayCache<String> replayCache;

    public void setEnforceAssertionsSigned(boolean enforceAssertionsSigned) {
        this.enforceAssertionsSigned = enforceAssertionsSigned;
    }

    public void setEnforceKnownIssuer(boolean enforceKnownIssuer) {
        this.enforceKnownIssuer = enforceKnownIssuer;
    }

    public SSOValidatorResponse validateSamlResponse(Response samlResponse, boolean postBinding) throws WSSecurityException {
        this.validateIssuer(samlResponse.getIssuer());
        if (samlResponse.getAssertions() == null || samlResponse.getAssertions().isEmpty()) {
            LOG.fine("The Response must contain at least one Assertion");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        String destination = samlResponse.getDestination();
        if (samlResponse.isSigned() && (destination == null || !destination.equals(this.assertionConsumerURL))) {
            LOG.fine("The Response must contain a destination that matches the assertion consumer URL");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        boolean foundValidSubject = false;
        Date sessionNotOnOrAfter = null;
        for (Assertion assertion : samlResponse.getAssertions()) {
            Subject subject;
            if (assertion.getIssuer() == null) {
                LOG.fine("Assertion Issuer must not be null");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
            }
            this.validateIssuer(assertion.getIssuer());
            if (this.enforceAssertionsSigned && postBinding && assertion.getSignature() == null) {
                LOG.fine("If the HTTP Post binding is used to deliver the Response, the enclosed assertions must be signed");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
            }
            if (assertion.getAuthnStatements() == null || assertion.getAuthnStatements().isEmpty() || !this.validateAuthenticationSubject(subject = assertion.getSubject(), assertion.getID(), postBinding)) continue;
            this.validateAudienceRestrictionCondition(assertion.getConditions());
            foundValidSubject = true;
            for (AuthnStatement authnStatment : assertion.getAuthnStatements()) {
                if (authnStatment.getSessionNotOnOrAfter() == null) continue;
                sessionNotOnOrAfter = authnStatment.getSessionNotOnOrAfter().toDate();
            }
        }
        if (!foundValidSubject) {
            LOG.fine("The Response did not contain any Authentication Statement that matched the Subject Confirmation criteria");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        SSOValidatorResponse validatorResponse = new SSOValidatorResponse();
        validatorResponse.setResponseId(samlResponse.getID());
        validatorResponse.setSessionNotOnOrAfter(sessionNotOnOrAfter);
        Element assertionElement = ((Assertion)samlResponse.getAssertions().get(0)).getDOM();
        validatorResponse.setAssertion(DOM2Writer.nodeToString((Node)assertionElement.cloneNode(true)));
        return validatorResponse;
    }

    private void validateIssuer(Issuer issuer) throws WSSecurityException {
        if (issuer == null) {
            return;
        }
        if (this.enforceKnownIssuer && !this.issuerIDP.startsWith(issuer.getValue())) {
            LOG.fine("Issuer value: " + issuer.getValue() + " does not match issuer IDP: " + this.issuerIDP);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        if (issuer.getFormat() != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(issuer.getFormat())) {
            LOG.fine("Issuer format is not null and does not equal: urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
    }

    private boolean validateAuthenticationSubject(Subject subject, String id, boolean postBinding) throws WSSecurityException {
        if (subject.getSubjectConfirmations() == null) {
            return false;
        }
        boolean foundBearerSubjectConf = false;
        for (SubjectConfirmation subjectConf : subject.getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConf.getMethod())) continue;
            foundBearerSubjectConf = true;
            this.validateSubjectConfirmation(subjectConf.getSubjectConfirmationData(), id, postBinding);
        }
        return foundBearerSubjectConf;
    }

    private void validateSubjectConfirmation(SubjectConfirmationData subjectConfData, String id, boolean postBinding) throws WSSecurityException {
        if (subjectConfData == null) {
            LOG.fine("Subject Confirmation Data of a Bearer Subject Confirmation is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        String recipient = subjectConfData.getRecipient();
        if (recipient == null || !recipient.equals(this.assertionConsumerURL)) {
            LOG.fine("Recipient " + recipient + " does not match assertion consumer URL " + this.assertionConsumerURL);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        if (subjectConfData.getNotOnOrAfter() == null || subjectConfData.getNotOnOrAfter().isBeforeNow()) {
            LOG.fine("Subject Conf Data does not contain NotOnOrAfter or it has expired");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        if (postBinding && this.replayCache != null) {
            if (this.replayCache.getId(id) == null) {
                Date expires = subjectConfData.getNotOnOrAfter().toDate();
                Date currentTime = new Date();
                long ttl = expires.getTime() - currentTime.getTime();
                this.replayCache.putId(id, ttl / 1000L);
            } else {
                LOG.fine("Replay attack with token id: " + id);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
            }
        }
        if (subjectConfData.getAddress() != null && !subjectConfData.getAddress().equals(this.clientAddress)) {
            LOG.fine("Subject Conf Data address " + subjectConfData.getAddress() + " does match" + " client address " + this.clientAddress);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        if (subjectConfData.getNotBefore() != null) {
            LOG.fine("The Subject Conf Data must not contain a NotBefore timestamp");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        if (this.requestId != null && !this.requestId.equals(subjectConfData.getInResponseTo())) {
            LOG.fine("The InResponseTo String does match the original request id " + this.requestId);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
    }

    private void validateAudienceRestrictionCondition(Conditions conditions) throws WSSecurityException {
        if (conditions == null) {
            LOG.fine("Conditions are null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        List audienceRestrs = conditions.getAudienceRestrictions();
        if (!this.matchSaml2AudienceRestriction(this.spIdentifier, audienceRestrs)) {
            LOG.fine("Assertion does not contain unique subject provider identifier " + this.spIdentifier + " in the audience restriction conditions");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
    }

    private boolean matchSaml2AudienceRestriction(String appliesTo, List<AudienceRestriction> audienceRestrictions) {
        boolean found = false;
        if (audienceRestrictions != null && !audienceRestrictions.isEmpty()) {
            for (AudienceRestriction audienceRestriction : audienceRestrictions) {
                if (audienceRestriction.getAudiences() == null) continue;
                for (Audience audience : audienceRestriction.getAudiences()) {
                    if (!appliesTo.equals(audience.getAudienceURI())) continue;
                    return true;
                }
            }
        }
        return found;
    }

    public String getIssuerIDP() {
        return this.issuerIDP;
    }

    public void setIssuerIDP(String issuerIDP) {
        this.issuerIDP = issuerIDP;
    }

    public String getAssertionConsumerURL() {
        return this.assertionConsumerURL;
    }

    public void setAssertionConsumerURL(String assertionConsumerURL) {
        this.assertionConsumerURL = assertionConsumerURL;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getSpIdentifier() {
        return this.spIdentifier;
    }

    public void setSpIdentifier(String spIdentifier) {
        this.spIdentifier = spIdentifier;
    }

    public void setReplayCache(TokenReplayCache<String> replayCache) {
        this.replayCache = replayCache;
    }
}

