/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.FSDirAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSDirAttrOp {
    public static final Log LOG = LogFactory.getLog(TestFSDirAttrOp.class);

    private boolean unprotectedSetTimes(long atime, long atime0, long precision, long mtime, boolean force) throws QuotaExceededException, UnresolvedLinkException {
        FSDirectory fsd = (FSDirectory)Mockito.mock(FSDirectory.class);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
        INode inode = (INode)Mockito.mock(INode.class);
        Mockito.when((Object)fsd.getFSNamesystem()).thenReturn((Object)fsn);
        Mockito.when((Object)fsn.getAccessTimePrecision()).thenReturn((Object)precision);
        Mockito.when((Object)fsd.getINodesInPath("", true)).thenReturn((Object)iip);
        Mockito.when((Object)fsd.hasWriteLock()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)iip.getLastINode()).thenReturn((Object)inode);
        Mockito.when((Object)iip.getLatestSnapshotId()).thenReturn((Object)Mockito.anyInt());
        Mockito.when((Object)inode.getAccessTime()).thenReturn((Object)atime0);
        return FSDirAttrOp.unprotectedSetTimes((FSDirectory)fsd, (String)"", (long)mtime, (long)atime, (boolean)force);
    }

    @Test
    public void testUnprotectedSetTimes() throws Exception {
        Assert.assertFalse((String)"SetTimes should not update access time because it's within the last precision interval", (boolean)this.unprotectedSetTimes(100L, 0L, 1000L, -1L, false));
        Assert.assertFalse((String)"SetTimes should not update access time because it's within the last precision interval", (boolean)this.unprotectedSetTimes(1000L, 0L, 1000L, -1L, false));
        Assert.assertTrue((String)"SetTimes should update access time", (boolean)this.unprotectedSetTimes(1011L, 10L, 1000L, -1L, false));
        Assert.assertTrue((String)"SetTimes should update access time", (boolean)this.unprotectedSetTimes(100L, 0L, 1000L, -1L, true));
        Assert.assertTrue((String)"SetTimes should update access time", (boolean)this.unprotectedSetTimes(100L, 0L, 1000L, 1L, false));
    }
}

