/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.net.NetworkTopology;

public class TestGetSplitHosts
extends TestCase {
    public void testGetSplitHosts() throws Exception {
        int numBlocks = 3;
        int block1Size = 100;
        int block2Size = 150;
        int block3Size = 75;
        int fileSize = block1Size + block2Size + block3Size;
        int replicationFactor = 3;
        NetworkTopology clusterMap = new NetworkTopology();
        BlockLocation[] bs = new BlockLocation[numBlocks];
        String[] block1Hosts = new String[]{"host1", "host2", "host3"};
        String[] block1Names = new String[]{"host1:100", "host2:100", "host3:100"};
        String[] block1Racks = new String[]{"/rack1/", "/rack1/", "/rack2/"};
        String[] block1Paths = new String[replicationFactor];
        for (int i = 0; i < replicationFactor; ++i) {
            block1Paths[i] = block1Racks[i] + block1Names[i];
        }
        bs[0] = new BlockLocation(block1Names, block1Hosts, block1Paths, 0L, (long)block1Size);
        String[] block2Hosts = new String[]{"host4", "host5", "host6"};
        String[] block2Names = new String[]{"host4:100", "host5:100", "host6:100"};
        String[] block2Racks = new String[]{"/rack2/", "/rack3/", "/rack3/"};
        String[] block2Paths = new String[replicationFactor];
        for (int i = 0; i < replicationFactor; ++i) {
            block2Paths[i] = block2Racks[i] + block2Names[i];
        }
        bs[1] = new BlockLocation(block2Names, block2Hosts, block2Paths, (long)block1Size, (long)block2Size);
        String[] block3Hosts = new String[]{"host1", "host7", "host8"};
        String[] block3Names = new String[]{"host1:100", "host7:100", "host8:100"};
        String[] block3Racks = new String[]{"/rack1/", "/rack4/", "/rack4/"};
        String[] block3Paths = new String[replicationFactor];
        for (int i = 0; i < replicationFactor; ++i) {
            block3Paths[i] = block3Racks[i] + block3Names[i];
        }
        bs[2] = new BlockLocation(block3Names, block3Hosts, block3Paths, (long)(block1Size + block2Size), (long)block3Size);
        SequenceFileInputFormat sif = new SequenceFileInputFormat();
        String[] hosts = sif.getSplitHosts(bs, 0L, (long)fileSize, clusterMap);
        TestGetSplitHosts.assertTrue((hosts.length == replicationFactor ? 1 : 0) != 0);
        TestGetSplitHosts.assertTrue((boolean)hosts[0].equalsIgnoreCase("host4"));
        TestGetSplitHosts.assertTrue((boolean)hosts[1].equalsIgnoreCase("host3"));
        TestGetSplitHosts.assertTrue((boolean)hosts[2].equalsIgnoreCase("host1"));
        bs[0] = new BlockLocation(block1Names, block1Hosts, 0L, (long)block1Size);
        bs[1] = new BlockLocation(block2Names, block2Hosts, (long)block1Size, (long)block2Size);
        bs[2] = new BlockLocation(block3Names, block3Hosts, (long)(block1Size + block2Size), (long)block3Size);
        hosts = sif.getSplitHosts(bs, 0L, (long)fileSize, clusterMap);
        TestGetSplitHosts.assertTrue((hosts.length == replicationFactor ? 1 : 0) != 0);
        TestGetSplitHosts.assertTrue((boolean)hosts[0].equalsIgnoreCase("host1"));
    }
}

