/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Bytes;

public class DescribeGroupsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<DescribedGroup> groups;
    public static final Schema SCHEMA_0 = new Schema(new Field("groups", new ArrayOf(DescribedGroup.SCHEMA_0), "Each described group."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public DescribeGroupsResponseData(Readable readable, short version) {
        this.groups = new ArrayList<DescribedGroup>();
        this.read(readable, version);
    }

    public DescribeGroupsResponseData(Struct struct, short version) {
        this.groups = new ArrayList<DescribedGroup>();
        this.fromStruct(struct, version);
    }

    public DescribeGroupsResponseData() {
        this.throttleTimeMs = 0;
        this.groups = new ArrayList<DescribedGroup>();
    }

    @Override
    public short apiKey() {
        return 15;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.groups.clear();
        } else {
            this.groups.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.groups.add(new DescribedGroup(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeInt(this.groups.size());
        for (DescribedGroup element : this.groups) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        Object[] nestedObjects = struct.getArray("groups");
        this.groups = new ArrayList<DescribedGroup>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.groups.add(new DescribedGroup((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] nestedObjects = new Struct[this.groups.size()];
        int i = 0;
        for (DescribedGroup element : this.groups) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("groups", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (version >= 1) {
            size += 4;
        }
        size += 4;
        for (DescribedGroup element : this.groups) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeGroupsResponseData)) {
            return false;
        }
        DescribeGroupsResponseData other = (DescribeGroupsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.groups == null ? other.groups != null : !this.groups.equals(other.groups));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DescribeGroupsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", groups=" + MessageUtil.deepToString(this.groups.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DescribedGroup> groups() {
        return this.groups;
    }

    public DescribeGroupsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeGroupsResponseData setGroups(List<DescribedGroup> v) {
        this.groups = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("groups", new ArrayOf(DescribedGroup.SCHEMA_0), "Each described group."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class DescribedGroupMember
    implements Message {
        private String memberId;
        private String clientId;
        private String clientHost;
        private byte[] memberMetadata;
        private byte[] memberAssignment;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DescribedGroupMember(Readable readable, short version) {
            this.read(readable, version);
        }

        public DescribedGroupMember(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DescribedGroupMember() {
            this.memberId = "";
            this.clientId = "";
            this.clientHost = "";
            this.memberMetadata = Bytes.EMPTY;
            this.memberAssignment = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.memberId = readable.readNullableString();
            this.clientId = readable.readNullableString();
            this.clientHost = readable.readNullableString();
            this.memberMetadata = readable.readNullableBytes();
            this.memberAssignment = readable.readNullableBytes();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.memberId);
            writable.writeString(this.clientId);
            writable.writeString(this.clientHost);
            writable.writeBytes(this.memberMetadata);
            writable.writeBytes(this.memberAssignment);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.memberId = struct.getString("member_id");
            this.clientId = struct.getString("client_id");
            this.clientHost = struct.getString("client_host");
            this.memberMetadata = struct.getByteArray("member_metadata");
            this.memberAssignment = struct.getByteArray("member_assignment");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("member_id", (Object)this.memberId);
            struct.set("client_id", (Object)this.clientId);
            struct.set("client_host", (Object)this.clientHost);
            struct.setByteArray("member_metadata", this.memberMetadata);
            struct.setByteArray("member_assignment", this.memberAssignment);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.memberId);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.clientId);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.clientHost);
            size += 4;
            size += this.memberMetadata.length;
            size += 4;
            return size += this.memberAssignment.length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedGroupMember)) {
                return false;
            }
            DescribedGroupMember other = (DescribedGroupMember)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
                return false;
            }
            if (this.clientHost == null ? other.clientHost != null : !this.clientHost.equals(other.clientHost)) {
                return false;
            }
            if (!Arrays.equals(this.memberMetadata, other.memberMetadata)) {
                return false;
            }
            return Arrays.equals(this.memberAssignment, other.memberAssignment);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
            hashCode = 31 * hashCode + (this.clientHost == null ? 0 : this.clientHost.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.memberMetadata);
            hashCode = 31 * hashCode + Arrays.hashCode(this.memberAssignment);
            return hashCode;
        }

        public String toString() {
            return "DescribedGroupMember(memberId='" + this.memberId + "', clientId='" + this.clientId + "', clientHost='" + this.clientHost + "', memberMetadata=" + Arrays.toString(this.memberMetadata) + ", memberAssignment=" + Arrays.toString(this.memberAssignment) + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public byte[] memberMetadata() {
            return this.memberMetadata;
        }

        public byte[] memberAssignment() {
            return this.memberAssignment;
        }

        public DescribedGroupMember setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public DescribedGroupMember setClientId(String v) {
            this.clientId = v;
            return this;
        }

        public DescribedGroupMember setClientHost(String v) {
            this.clientHost = v;
            return this;
        }

        public DescribedGroupMember setMemberMetadata(byte[] v) {
            this.memberMetadata = v;
            return this;
        }

        public DescribedGroupMember setMemberAssignment(byte[] v) {
            this.memberAssignment = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("client_id", Type.STRING, "The client ID used in the member's latest join group request."), new Field("client_host", Type.STRING, "The client host."), new Field("member_metadata", Type.BYTES, "The metadata corresponding to the current group protocol in use."), new Field("member_assignment", Type.BYTES, "The current assignment provided by the group leader.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class DescribedGroup
    implements Message {
        private short errorCode;
        private String groupId;
        private String groupState;
        private String protocolType;
        private String protocolData;
        private List<DescribedGroupMember> members;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DescribedGroup(Readable readable, short version) {
            this.members = new ArrayList<DescribedGroupMember>();
            this.read(readable, version);
        }

        public DescribedGroup(Struct struct, short version) {
            this.members = new ArrayList<DescribedGroupMember>();
            this.fromStruct(struct, version);
        }

        public DescribedGroup() {
            this.errorCode = 0;
            this.groupId = "";
            this.groupState = "";
            this.protocolType = "";
            this.protocolData = "";
            this.members = new ArrayList<DescribedGroupMember>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.groupId = readable.readNullableString();
            this.groupState = readable.readNullableString();
            this.protocolType = readable.readNullableString();
            this.protocolData = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.members.clear();
            } else {
                this.members.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.members.add(new DescribedGroupMember(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeString(this.groupId);
            writable.writeString(this.groupState);
            writable.writeString(this.protocolType);
            writable.writeString(this.protocolData);
            writable.writeInt(this.members.size());
            for (DescribedGroupMember element : this.members) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.groupId = struct.getString("group_id");
            this.groupState = struct.getString("group_state");
            this.protocolType = struct.getString("protocol_type");
            this.protocolData = struct.getString("protocol_data");
            Object[] nestedObjects = struct.getArray("members");
            this.members = new ArrayList<DescribedGroupMember>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.members.add(new DescribedGroupMember((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("group_id", (Object)this.groupId);
            struct.set("group_state", (Object)this.groupState);
            struct.set("protocol_type", (Object)this.protocolType);
            struct.set("protocol_data", (Object)this.protocolData);
            Struct[] nestedObjects = new Struct[this.members.size()];
            int i = 0;
            for (DescribedGroupMember element : this.members) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("members", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.groupId);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.groupState);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.protocolType);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.protocolData);
            size += 4;
            for (DescribedGroupMember element : this.members) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedGroup)) {
                return false;
            }
            DescribedGroup other = (DescribedGroup)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.groupState == null ? other.groupState != null : !this.groupState.equals(other.groupState)) {
                return false;
            }
            if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
                return false;
            }
            if (this.protocolData == null ? other.protocolData != null : !this.protocolData.equals(other.protocolData)) {
                return false;
            }
            return !(this.members == null ? other.members != null : !this.members.equals(other.members));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            hashCode = 31 * hashCode + (this.groupState == null ? 0 : this.groupState.hashCode());
            hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
            hashCode = 31 * hashCode + (this.protocolData == null ? 0 : this.protocolData.hashCode());
            hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribedGroup(errorCode=" + this.errorCode + ", groupId='" + this.groupId + "', groupState='" + this.groupState + "', protocolType='" + this.protocolType + "', protocolData='" + this.protocolData + "', members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String groupId() {
            return this.groupId;
        }

        public String groupState() {
            return this.groupState;
        }

        public String protocolType() {
            return this.protocolType;
        }

        public String protocolData() {
            return this.protocolData;
        }

        public List<DescribedGroupMember> members() {
            return this.members;
        }

        public DescribedGroup setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribedGroup setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public DescribedGroup setGroupState(String v) {
            this.groupState = v;
            return this;
        }

        public DescribedGroup setProtocolType(String v) {
            this.protocolType = v;
            return this;
        }

        public DescribedGroup setProtocolData(String v) {
            this.protocolData = v;
            return this;
        }

        public DescribedGroup setMembers(List<DescribedGroupMember> v) {
            this.members = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The describe error, or 0 if there was no error."), new Field("group_id", Type.STRING, "The group ID string."), new Field("group_state", Type.STRING, "The group state string, or the empty string."), new Field("protocol_type", Type.STRING, "The group protocol type, or the empty string."), new Field("protocol_data", Type.STRING, "The group protocol data, or the empty string."), new Field("members", new ArrayOf(DescribedGroupMember.SCHEMA_0), "The group members.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

