/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.eventusermodel;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFSheetXMLHandler
extends DefaultHandler {
    private static final POILogger logger = POILogFactory.getLogger(XSSFSheetXMLHandler.class);
    private StylesTable stylesTable;
    private CommentsTable commentsTable;
    private ReadOnlySharedStringsTable sharedStringsTable;
    private final SheetContentsHandler output;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private final DataFormatter formatter;
    private int rowNum;
    private int nextRowNum;
    private String cellRef;
    private boolean formulasNotResults;
    private StringBuffer value = new StringBuffer();
    private StringBuffer formula = new StringBuffer();
    private StringBuffer headerFooter = new StringBuffer();
    private Queue<CellReference> commentCellRefs;
    private static final Comparator<CellReference> cellRefComparator = new Comparator<CellReference>(){

        @Override
        public int compare(CellReference o1, CellReference o2) {
            int result = this.compare(o1.getRow(), o2.getRow());
            if (result == 0) {
                result = this.compare(o1.getCol(), o2.getCol());
            }
            return result;
        }

        @Override
        public int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    };

    public XSSFSheetXMLHandler(StylesTable styles, CommentsTable comments, ReadOnlySharedStringsTable strings, SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean formulasNotResults) {
        this.stylesTable = styles;
        this.commentsTable = comments;
        this.sharedStringsTable = strings;
        this.output = sheetContentsHandler;
        this.formulasNotResults = formulasNotResults;
        this.nextDataType = xssfDataType.NUMBER;
        this.formatter = dataFormatter;
        this.init();
    }

    public XSSFSheetXMLHandler(StylesTable styles, ReadOnlySharedStringsTable strings, SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean formulasNotResults) {
        this(styles, null, strings, sheetContentsHandler, dataFormatter, formulasNotResults);
    }

    public XSSFSheetXMLHandler(StylesTable styles, ReadOnlySharedStringsTable strings, SheetContentsHandler sheetContentsHandler, boolean formulasNotResults) {
        this(styles, strings, sheetContentsHandler, new DataFormatter(), formulasNotResults);
    }

    private void init() {
        if (this.commentsTable != null) {
            this.commentCellRefs = new LinkedList<CellReference>();
            for (CTComment comment : this.commentsTable.getCTComments().getCommentList().getCommentArray()) {
                this.commentCellRefs.add(new CellReference(comment.getRef()));
            }
        }
    }

    private boolean isTextTag(String name) {
        if ("v".equals(name)) {
            return true;
        }
        if ("inlineStr".equals(name)) {
            return true;
        }
        return "t".equals(name) && this.isIsOpen;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.isTextTag(name)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if ("is".equals(name)) {
            this.isIsOpen = true;
        } else if ("f".equals(name)) {
            String type;
            this.formula.setLength(0);
            if (this.nextDataType == xssfDataType.NUMBER) {
                this.nextDataType = xssfDataType.FORMULA;
            }
            if ((type = attributes.getValue("t")) != null && type.equals("shared")) {
                String ref = attributes.getValue("ref");
                String si = attributes.getValue("si");
                if (ref != null) {
                    this.fIsOpen = true;
                } else if (this.formulasNotResults) {
                    logger.log(5, (Object)"shared formulas not yet supported!");
                }
            } else {
                this.fIsOpen = true;
            }
        } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name) || "firstFooter".equals(name) || "oddFooter".equals(name) || "evenFooter".equals(name)) {
            this.hfIsOpen = true;
            this.headerFooter.setLength(0);
        } else if ("row".equals(name)) {
            String rowNumStr = attributes.getValue("r");
            this.rowNum = rowNumStr != null ? Integer.parseInt(rowNumStr) - 1 : this.nextRowNum;
            this.output.startRow(this.rowNum);
        } else if ("c".equals(name)) {
            this.nextDataType = xssfDataType.NUMBER;
            this.formatIndex = (short)-1;
            this.formatString = null;
            this.cellRef = attributes.getValue("r");
            String cellType = attributes.getValue("t");
            String cellStyleStr = attributes.getValue("s");
            if ("b".equals(cellType)) {
                this.nextDataType = xssfDataType.BOOLEAN;
            } else if ("e".equals(cellType)) {
                this.nextDataType = xssfDataType.ERROR;
            } else if ("inlineStr".equals(cellType)) {
                this.nextDataType = xssfDataType.INLINE_STRING;
            } else if ("s".equals(cellType)) {
                this.nextDataType = xssfDataType.SST_STRING;
            } else if ("str".equals(cellType)) {
                this.nextDataType = xssfDataType.FORMULA;
            } else {
                XSSFCellStyle style = null;
                if (cellStyleStr != null) {
                    int styleIndex = Integer.parseInt(cellStyleStr);
                    style = this.stylesTable.getStyleAt(styleIndex);
                } else if (this.stylesTable.getNumCellStyles() > 0) {
                    style = this.stylesTable.getStyleAt(0);
                }
                if (style != null) {
                    this.formatIndex = style.getDataFormat();
                    this.formatString = style.getDataFormatString();
                    if (this.formatString == null) {
                        this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        String thisStr = null;
        if (this.isTextTag(name)) {
            this.vIsOpen = false;
            switch (this.nextDataType) {
                case BOOLEAN: {
                    char first = this.value.charAt(0);
                    thisStr = first == '0' ? "FALSE" : "TRUE";
                    break;
                }
                case ERROR: {
                    thisStr = "ERROR:" + this.value.toString();
                    break;
                }
                case FORMULA: {
                    if (this.formulasNotResults) {
                        thisStr = this.formula.toString();
                        break;
                    }
                    String fv = this.value.toString();
                    if (this.formatString != null) {
                        try {
                            double d = Double.parseDouble(fv);
                            thisStr = this.formatter.formatRawCellContents(d, (int)this.formatIndex, this.formatString);
                        }
                        catch (NumberFormatException e) {
                            thisStr = fv;
                        }
                        break;
                    }
                    thisStr = fv;
                    break;
                }
                case INLINE_STRING: {
                    XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                    thisStr = rtsi.toString();
                    break;
                }
                case SST_STRING: {
                    String sstIndex = this.value.toString();
                    try {
                        int idx = Integer.parseInt(sstIndex);
                        XSSFRichTextString rtss = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                        thisStr = rtss.toString();
                    }
                    catch (NumberFormatException ex) {
                        logger.log(7, (Object)("Failed to parse SST index '" + sstIndex), (Throwable)ex);
                    }
                    break;
                }
                case NUMBER: {
                    String n = this.value.toString();
                    if (this.formatString != null && n.length() > 0) {
                        thisStr = this.formatter.formatRawCellContents(Double.parseDouble(n), (int)this.formatIndex, this.formatString);
                        break;
                    }
                    thisStr = n;
                    break;
                }
                default: {
                    thisStr = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                }
            }
            this.checkForEmptyCellComments(EmptyCellCommentsCheckType.CELL);
            XSSFComment comment = this.commentsTable != null ? this.commentsTable.findCellComment(this.cellRef) : null;
            this.output.cell(this.cellRef, thisStr, comment);
        } else if ("f".equals(name)) {
            this.fIsOpen = false;
        } else if ("is".equals(name)) {
            this.isIsOpen = false;
        } else if ("row".equals(name)) {
            this.checkForEmptyCellComments(EmptyCellCommentsCheckType.END_OF_ROW);
            this.output.endRow(this.rowNum);
            this.nextRowNum = this.rowNum + 1;
        } else if ("sheetData".equals(name)) {
            this.checkForEmptyCellComments(EmptyCellCommentsCheckType.END_OF_SHEET_DATA);
        } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name)) {
            this.hfIsOpen = false;
            this.output.headerFooter(this.headerFooter.toString(), true, name);
        } else if ("oddFooter".equals(name) || "evenFooter".equals(name) || "firstFooter".equals(name)) {
            this.hfIsOpen = false;
            this.output.headerFooter(this.headerFooter.toString(), false, name);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
        if (this.fIsOpen) {
            this.formula.append(ch, start, length);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(ch, start, length);
        }
    }

    private void checkForEmptyCellComments(EmptyCellCommentsCheckType type) {
        if (this.commentCellRefs != null && !this.commentCellRefs.isEmpty()) {
            CellReference nextCommentCellRef;
            if (type == EmptyCellCommentsCheckType.END_OF_SHEET_DATA) {
                while (!this.commentCellRefs.isEmpty()) {
                    this.outputEmptyCellComment(this.commentCellRefs.remove());
                }
                return;
            }
            if (this.cellRef == null) {
                if (type == EmptyCellCommentsCheckType.END_OF_ROW) {
                    while (!this.commentCellRefs.isEmpty()) {
                        if (this.commentCellRefs.peek().getRow() == this.rowNum) {
                            this.outputEmptyCellComment(this.commentCellRefs.remove());
                            continue;
                        }
                        return;
                    }
                    return;
                }
                throw new IllegalStateException("Cell ref should be null only if there are only empty cells in the row; rowNum: " + this.rowNum);
            }
            do {
                CellReference cellRef = new CellReference(this.cellRef);
                CellReference peekCellRef = this.commentCellRefs.peek();
                if (type == EmptyCellCommentsCheckType.CELL && cellRef.equals((Object)peekCellRef)) {
                    this.commentCellRefs.remove();
                    return;
                }
                int comparison = cellRefComparator.compare(peekCellRef, cellRef);
                if (comparison > 0 && type == EmptyCellCommentsCheckType.END_OF_ROW && peekCellRef.getRow() <= this.rowNum) {
                    nextCommentCellRef = this.commentCellRefs.remove();
                    this.outputEmptyCellComment(nextCommentCellRef);
                    continue;
                }
                if (comparison < 0 && type == EmptyCellCommentsCheckType.CELL && peekCellRef.getRow() <= this.rowNum) {
                    nextCommentCellRef = this.commentCellRefs.remove();
                    this.outputEmptyCellComment(nextCommentCellRef);
                    continue;
                }
                nextCommentCellRef = null;
            } while (nextCommentCellRef != null && !this.commentCellRefs.isEmpty());
        }
    }

    private void outputEmptyCellComment(CellReference cellRef) {
        String cellRefString = cellRef.formatAsString();
        XSSFComment comment = this.commentsTable.findCellComment(cellRefString);
        this.output.cell(cellRefString, null, comment);
    }

    public static interface SheetContentsHandler {
        public void startRow(int var1);

        public void endRow(int var1);

        public void cell(String var1, String var2, XSSFComment var3);

        public void headerFooter(String var1, boolean var2, String var3);
    }

    private static enum EmptyCellCommentsCheckType {
        CELL,
        END_OF_ROW,
        END_OF_SHEET_DATA;

    }

    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }
}

