/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.AbstractAppAssemblerMojo;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.mojo.appassembler.util.FileFilterHelper;

public abstract class AbstractScriptGeneratorMojo
extends AbstractAppAssemblerMojo {
    protected String environmentSetupFileName;
    protected File licenseHeaderFile;
    protected String unixScriptTemplate;
    protected boolean useWildcardClassPath;
    protected String windowsScriptTemplate;
    protected List artifacts;
    protected MavenProject mavenProject;
    protected boolean generateRepository;
    protected String configurationDirectory;
    protected File configurationSourceDirectory;
    protected boolean copyConfigurationDirectory;
    protected String endorsedDir;
    protected DaemonGeneratorService daemonGeneratorService;

    protected void doCopyConfigurationDirectory(String targetDirectory) throws MojoFailureException {
        boolean success;
        if (!this.configurationSourceDirectory.exists()) {
            throw new MojoFailureException("The source directory for configuration files does not exist: " + this.configurationSourceDirectory.getAbsolutePath());
        }
        this.getLog().debug((CharSequence)"copying configuration directory.");
        File configurationTargetDirectory = new File(targetDirectory, this.configurationDirectory);
        if (!configurationTargetDirectory.exists() && !(success = configurationTargetDirectory.mkdirs())) {
            throw new MojoFailureException("Failed to create the target directory for configuration files: " + configurationTargetDirectory.getAbsolutePath());
        }
        try {
            this.getLog().debug((CharSequence)("Will try to copy configuration files from " + this.configurationSourceDirectory.getAbsolutePath() + " to " + configurationTargetDirectory.getAbsolutePath()));
            FileUtils.copyDirectory((File)this.configurationSourceDirectory, (File)configurationTargetDirectory, (FileFilter)FileFilterHelper.createDefaultFilter());
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy the configuration files.");
        }
    }

    protected void installDependencies(String outputDirectory, String repositoryName) throws MojoExecutionException, MojoFailureException {
        if (this.generateRepository) {
            ArtifactRepository artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", "file://" + outputDirectory + "/" + repositoryName, this.getArtifactRepositoryLayout(), false);
            Iterator it = this.artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                this.installArtifact(artifact, artifactRepository, this.useTimestampInSnapshotFileName);
            }
            this.installArtifact(this.projectArtifact, artifactRepository);
        }
    }
}

