/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.testing.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logging;
import org.hibernate.build.gradle.testing.database.DatabaseProfile;
import org.slf4j.Logger;

public abstract class AbstractDatabaseProfileImpl
implements DatabaseProfile {
    private static final Logger log = Logging.getLogger(AbstractDatabaseProfileImpl.class);
    private final String name;
    private final File profileDirectory;
    private final Project project;
    private final Map<String, Object> hibernateProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractDatabaseProfileImpl(File profileDirectory, Project project) {
        this.profileDirectory = profileDirectory;
        this.name = profileDirectory.getName();
        this.project = project;
        this.hibernateProperties = new HashMap<String, Object>();
        File hibernatePropertiesFile = new File(new File(profileDirectory, "resources"), "hibernate.properties");
        if (hibernatePropertiesFile.exists()) {
            Properties props = new Properties();
            try {
                FileInputStream stream = new FileInputStream(hibernatePropertiesFile);
                try {
                    props.load(stream);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e) {
                log.warn("Unable to read Hibernate properties for database profile [" + this.name + "]", (Throwable)e);
            }
            for (String propName : props.stringPropertyNames()) {
                this.hibernateProperties.put(propName, props.getProperty(propName));
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getDirectory() {
        return this.profileDirectory;
    }

    @Override
    public Map<String, Object> getHibernateProperties() {
        return this.hibernateProperties;
    }

    protected Configuration prepareConfiguration(String name) {
        Configuration configuration = this.getOrCreateConfiguration(name);
        configuration.setDescription("The JDBC dependency configuration for the [" + name + "] profile");
        return configuration;
    }

    protected Configuration getOrCreateConfiguration(String name) {
        Configuration configuration = (Configuration)this.project.getConfigurations().findByName(name);
        if (configuration == null) {
            configuration = (Configuration)this.project.getConfigurations().create(name);
        }
        return configuration;
    }
}

