/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.testing.database;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.hibernate.build.gradle.testing.database.DatabaseProfile;
import org.hibernate.build.gradle.testing.database.JdbcDirectoryProfile;
import org.hibernate.build.gradle.testing.database.MatrixDotGradleProfile;

public class DatabaseProfilePlugin
implements Plugin<Project> {
    public static final String STANDARD_DATABASES_DIRECTORY = "databases";
    public static final String CUSTOM_DATABASES_DIRECTORY_KEY = "hibernate-matrix-databases";
    public static final String HIBERNATE_MATRIX_IGNORE = "hibernate-matrix-ignore";
    private static final String MATRIX_BUILD_FILE = "matrix.gradle";
    private static final String JDBC_DIR = "jdbc";
    private static final Logger log = Logging.getLogger(DatabaseProfilePlugin.class);
    private Project project;
    private List<DatabaseProfile> profiles;
    private Set<String> ignored;

    public void apply(Project project) {
        this.project = project;
        LinkedHashMap<String, DatabaseProfile> profileMap = new LinkedHashMap<String, DatabaseProfile>();
        this.processStandardProfiles(profileMap);
        this.processCustomProfiles(profileMap);
        this.profiles = new ArrayList<DatabaseProfile>();
        for (DatabaseProfile profile : profileMap.values()) {
            this.profiles.add(profile);
        }
    }

    private void processStandardProfiles(Map<String, DatabaseProfile> profileMap) {
        File standardDatabasesDirectory = this.project.file((Object)STANDARD_DATABASES_DIRECTORY);
        if (standardDatabasesDirectory == null || !standardDatabasesDirectory.exists()) {
            log.debug("Standard databases directory [{}] did not exist", (Object)STANDARD_DATABASES_DIRECTORY);
            return;
        }
        if (!standardDatabasesDirectory.isDirectory()) {
            log.warn("Located standard databases directory [{}] was not a directory", (Object)STANDARD_DATABASES_DIRECTORY);
            return;
        }
        this.processProfiles(standardDatabasesDirectory, profileMap);
    }

    private void processProfiles(File directory, Map<String, DatabaseProfile> profileMap) {
        File jdbcDirectory;
        DatabaseProfile databaseProfile = null;
        File matrixDotGradleFile = new File(directory, MATRIX_BUILD_FILE);
        if (matrixDotGradleFile.exists() && matrixDotGradleFile.isFile()) {
            log.debug("Found matrix.gradle file : " + matrixDotGradleFile);
            databaseProfile = new MatrixDotGradleProfile(matrixDotGradleFile, this.project);
        }
        if ((jdbcDirectory = new File(directory, JDBC_DIR)).exists() && jdbcDirectory.isDirectory()) {
            databaseProfile = new JdbcDirectoryProfile(jdbcDirectory, this.project);
        }
        if (databaseProfile == null) {
            for (File subDirectory : directory.listFiles()) {
                if (!subDirectory.isDirectory()) continue;
                this.processProfiles(subDirectory, profileMap);
            }
            return;
        }
        String profileName = databaseProfile.getName();
        if (this.ignored().contains(profileName)) {
            log.debug("Skipping ignored database profile [{}]", (Object)profileName);
            return;
        }
        DatabaseProfile previousEntry = profileMap.put(profileName, databaseProfile);
        if (previousEntry != null) {
            log.lifecycle("Found duplicate profile definitions [name={}], [{}] taking precedence over [{}]", new Object[]{profileName, databaseProfile.getDirectory().getAbsolutePath(), previousEntry.getDirectory().getAbsolutePath()});
        }
    }

    private Set<String> ignored() {
        if (this.ignored == null) {
            String values = System.getProperty(HIBERNATE_MATRIX_IGNORE);
            if (values == null || values.length() == 0) {
                this.ignored = Collections.emptySet();
            } else {
                this.ignored = new HashSet<String>();
                Collections.addAll(this.ignored, values.split(","));
            }
        }
        return this.ignored;
    }

    private void processCustomProfiles(Map<String, DatabaseProfile> profileMap) {
        File customDatabaseDirectory;
        String customDatabaseDirectoryPath = System.getProperty(CUSTOM_DATABASES_DIRECTORY_KEY);
        if (customDatabaseDirectoryPath != null && customDatabaseDirectoryPath.length() > 0 && (customDatabaseDirectory = new File(customDatabaseDirectoryPath)).exists() && customDatabaseDirectory.isDirectory()) {
            this.processProfiles(customDatabaseDirectory, profileMap);
        }
    }

    public Iterable<DatabaseProfile> getDatabaseProfiles() {
        return this.profiles;
    }
}

